/*
 * Decompiled with CFR 0.152.
 */
package com.ichorpowered.iplog.command;

import com.ichorpowered.iplog.IPLog;
import java.net.InetAddress;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class PurgeCommand
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Optional optionalUser = args.getOne("player");
        if (!optionalUser.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "You must specify an existing user."}));
        }
        Optional optionalIP = args.getOne("ip");
        if (!optionalIP.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "You must specify a proper IP address."}));
        }
        User user = (User)optionalUser.get();
        InetAddress ip = (InetAddress)optionalIP.get();
        Sponge.getScheduler().createAsyncExecutor((Object)IPLog.getPlugin()).execute(() -> IPLog.getPlugin().getStorage().purgeConnection(ip, user.getUniqueId()));
        src.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, "You have successfully removed the specified connection from the database."}));
        return CommandResult.success();
    }
}

