/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.RecipeLoader;
import hellfirepvp.modularmachinery.common.crafting.command.RecipeCommandContainer;
import hellfirepvp.modularmachinery.common.crafting.command.RecipeRunnableCommand;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentSelectorTag;
import hellfirepvp.modularmachinery.common.crafting.requirements.RequirementEnergy;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class MachineRecipe
implements Comparable<MachineRecipe> {
    private static int counter = 0;
    private static final int PRIORITY_WEIGHT_ENERGY = 50000000;
    private static final int PRIORITY_WEIGHT_FLUID = 100;
    private static final int PRIORITY_WEIGHT_ITEM = 50000;
    private final int sortId;
    private final String recipeFilePath;
    private final ResourceLocation owningMachine;
    private final ResourceLocation registryName;
    private final int tickTime;
    private final List<ComponentRequirement> recipeRequirements = Lists.newArrayList();
    private final RecipeCommandContainer commandContainer = new RecipeCommandContainer();
    private final int configuredPriority;

    public MachineRecipe(String path, ResourceLocation registryName, ResourceLocation owningMachine, int tickTime, int configuredPriority) {
        this.sortId = counter++;
        this.recipeFilePath = path;
        this.registryName = registryName;
        this.owningMachine = owningMachine;
        this.tickTime = tickTime;
        this.configuredPriority = configuredPriority;
    }

    public String getRecipeFilePath() {
        return this.recipeFilePath;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public ResourceLocation getOwningMachineIdentifier() {
        return this.owningMachine;
    }

    public List<ComponentRequirement> getCraftingRequirements() {
        return Collections.unmodifiableList(this.recipeRequirements);
    }

    public RecipeCommandContainer getCommandContainer() {
        return this.commandContainer;
    }

    public void addRequirement(ComponentRequirement requirement) {
        if (requirement instanceof RequirementEnergy) {
            for (ComponentRequirement req : this.recipeRequirements) {
                if (!(req instanceof RequirementEnergy) || req.getActionType() != requirement.getActionType()) continue;
                throw new IllegalStateException("Tried to add multiple energy requirements for the same ioType! Please only add one for each ioType!");
            }
        }
        this.recipeRequirements.add(requirement);
    }

    public int getRecipeTotalTickTime() {
        return this.tickTime;
    }

    public int getConfiguredPriority() {
        return this.configuredPriority;
    }

    @Nullable
    public DynamicMachine getOwningMachine() {
        return MachineRegistry.getRegistry().getMachine(this.getOwningMachineIdentifier());
    }

    public MachineRecipe copy(Function<ResourceLocation, ResourceLocation> registryNameChange, ResourceLocation newOwningMachineIdentifier, List<RecipeModifier> modifiers) {
        MachineRecipe copy = new MachineRecipe(this.getRecipeFilePath(), registryNameChange.apply(this.getRegistryName()), newOwningMachineIdentifier, Math.round(RecipeModifier.applyModifiers(modifiers, "duration", null, this.getRecipeTotalTickTime(), false)), this.getConfiguredPriority());
        for (ComponentRequirement requirement : this.getCraftingRequirements()) {
            copy.addRequirement(requirement.deepCopyModified(modifiers));
        }
        return copy;
    }

    @Override
    public int compareTo(MachineRecipe o) {
        return Integer.compare(this.buildWeight(), o.buildWeight());
    }

    private int buildWeight() {
        int weightOut = this.sortId;
        for (ComponentRequirement req : this.recipeRequirements) {
            if (req.getActionType() == MachineComponent.IOType.OUTPUT) continue;
            switch (req.getRequiredComponentType().getRegistryName().toLowerCase()) {
                case "item": {
                    weightOut -= 50000;
                    break;
                }
                case "fluid": {
                    weightOut -= 100;
                    break;
                }
                case "energy": {
                    weightOut -= 50000000;
                }
            }
        }
        return weightOut;
    }

    public static class ComponentDeserializer
    implements JsonDeserializer<ComponentRequirement> {
        public ComponentRequirement<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonObject()) {
                throw new JsonParseException("Component Requirements have to be objects!");
            }
            JsonObject requirement = json.getAsJsonObject();
            if (!(requirement.has("type") && requirement.get("type").isJsonPrimitive() && requirement.get("type").getAsJsonPrimitive().isString())) {
                throw new JsonParseException("'type' of a requirement is missing or isn't a string!");
            }
            String type = requirement.getAsJsonPrimitive("type").getAsString();
            if (!(requirement.has("io-type") && requirement.get("io-type").isJsonPrimitive() && requirement.get("io-type").getAsJsonPrimitive().isString())) {
                throw new JsonParseException("'io-type' of a requirement is missing or isn't a string!");
            }
            String ioType = requirement.getAsJsonPrimitive("io-type").getAsString();
            ComponentType componentType = ComponentType.Registry.getComponent(type);
            if (componentType == null) {
                throw new JsonParseException("'" + type + "' is not a valid ComponentType!");
            }
            MachineComponent.IOType machineIoType = MachineComponent.IOType.getByString(ioType);
            if (machineIoType == null) {
                throw new JsonParseException("'" + ioType + "' is not a valid IOType!");
            }
            Object req = componentType.provideComponent(machineIoType, requirement);
            if (requirement.has("selector-tag")) {
                JsonElement strTag = requirement.get("selector-tag");
                if (!strTag.isJsonPrimitive()) {
                    throw new JsonParseException("The 'selector-tag' in an requirement must be a string!");
                }
                if (!strTag.getAsString().isEmpty()) {
                    ((ComponentRequirement)req).setTag(new ComponentSelectorTag(strTag.getAsString()));
                }
            }
            return req;
        }
    }

    public static class Deserializer
    implements JsonDeserializer<MachineRecipeContainer> {
        public MachineRecipeContainer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ResourceLocation parentName;
            JsonObject root = json.getAsJsonObject();
            if (!root.has("machine")) {
                throw new JsonParseException("No 'machine'-entry specified!");
            }
            if (!root.has("registryName") && !root.has("registryname")) {
                throw new JsonParseException("No 'registryName'-entry specified!");
            }
            if (!root.has("recipeTime")) {
                throw new JsonParseException("No 'recipeTime'-entry specified!");
            }
            JsonElement elementMachine = root.get("machine");
            LinkedList qualifiedMachineNames = Lists.newLinkedList();
            if (elementMachine.isJsonArray()) {
                if (elementMachine.getAsJsonArray().size() <= 0) {
                    throw new JsonParseException("'machine' is an array, but it's empty! Provide at least 1 owning-machine name!");
                }
                JsonArray jar = elementMachine.getAsJsonArray();
                for (JsonElement je : jar) {
                    if (je.isJsonPrimitive() && je.getAsJsonPrimitive().isString()) {
                        qualifiedMachineNames.add(new ResourceLocation("modularmachinery", je.getAsJsonPrimitive().getAsString()));
                        continue;
                    }
                    throw new JsonParseException("Found an element in the array specified in 'machine' that is not a string! " + je.toString());
                }
                if (qualifiedMachineNames.isEmpty()) {
                    throw new JsonParseException("'machine' is an array, but it's empty! Provide at least 1 owning-machine name!");
                }
            } else if (elementMachine.isJsonPrimitive() && elementMachine.getAsJsonPrimitive().isString()) {
                qualifiedMachineNames.add(new ResourceLocation("modularmachinery", elementMachine.getAsJsonPrimitive().getAsString()));
            } else {
                throw new JsonParseException("'machine' has to be either an array of strings or just a string! - Found " + elementMachine.toString() + " instead!");
            }
            JsonElement elementRegistryName = root.get("registryName");
            if (elementRegistryName == null) {
                elementRegistryName = root.get("registryname");
            }
            if (!elementRegistryName.isJsonPrimitive() || !elementRegistryName.getAsJsonPrimitive().isString()) {
                throw new JsonParseException("'registryName' has to have as value only a String that defines its unique registry name!");
            }
            JsonElement elementTime = root.get("recipeTime");
            if (!elementTime.isJsonPrimitive() || !elementTime.getAsJsonPrimitive().isNumber()) {
                throw new JsonParseException("'recipeTime' has to be a number!");
            }
            int priority = 0;
            if (root.has("priority")) {
                JsonElement elementPriority = root.get("priority");
                if (!elementPriority.isJsonPrimitive() || !elementPriority.getAsJsonPrimitive().isNumber()) {
                    throw new JsonParseException("'priority' has to be a number! (if specified)");
                }
                priority = elementPriority.getAsInt();
            }
            if ((parentName = (ResourceLocation)Iterables.getFirst((Iterable)qualifiedMachineNames, null)) == null) {
                throw new IllegalStateException("Couldn't find machine name from qualified-names list: " + Arrays.toString(qualifiedMachineNames.toArray()));
            }
            String registryName = elementRegistryName.getAsJsonPrimitive().getAsString();
            int recipeTime = elementTime.getAsJsonPrimitive().getAsInt();
            MachineRecipe recipe = new MachineRecipe(RecipeLoader.currentlyReadingPath, new ResourceLocation("modularmachinery", registryName), parentName, recipeTime, priority);
            MachineRecipeContainer outContainer = new MachineRecipeContainer(recipe);
            outContainer.recipeOwnerList.addAll(qualifiedMachineNames);
            if (!root.has("requirements")) {
                throw new JsonParseException("No 'requirements'-entry specified!");
            }
            JsonElement elementRequirements = root.get("requirements");
            if (!elementRequirements.isJsonArray()) {
                throw new JsonParseException("'requirements' should be an array of recipe requirements!");
            }
            JsonArray requirementsArray = elementRequirements.getAsJsonArray();
            for (int i = 0; i < requirementsArray.size(); ++i) {
                JsonElement elementRequirement = requirementsArray.get(i);
                if (!elementRequirement.isJsonObject()) {
                    throw new JsonParseException("Each element in the 'requirements' array needs to be a fully defined requirement-object!");
                }
                recipe.recipeRequirements.add(context.deserialize(elementRequirement, ComponentRequirement.class));
            }
            if (recipe.recipeRequirements.isEmpty()) {
                throw new JsonParseException("A recipe needs to have at least 1 requirement!");
            }
            this.loadCommands(root, context, "startCommands", cmd -> recipe.getCommandContainer().addStartCommand((RecipeRunnableCommand)cmd));
            this.loadCommands(root, context, "processingCommands", cmd -> recipe.getCommandContainer().addProcessingCommand((RecipeRunnableCommand)cmd));
            this.loadCommands(root, context, "finishCommands", cmd -> recipe.getCommandContainer().addFinishCommand((RecipeRunnableCommand)cmd));
            return outContainer;
        }

        private void loadCommands(JsonObject root, JsonDeserializationContext context, String arrayTag, Consumer<RecipeRunnableCommand> addFunction) {
            if (root.has(arrayTag)) {
                JsonElement elementStartCommands = root.get(arrayTag);
                if (!elementStartCommands.isJsonArray()) {
                    throw new JsonParseException(arrayTag + " should be an array of commands!");
                }
                for (JsonElement je : elementStartCommands.getAsJsonArray()) {
                    addFunction.accept((RecipeRunnableCommand)context.deserialize(je, RecipeRunnableCommand.class));
                }
            }
        }
    }

    public static class MachineRecipeContainer {
        private final MachineRecipe parent;
        private List<ResourceLocation> recipeOwnerList = Lists.newLinkedList();

        private MachineRecipeContainer(MachineRecipe copyParent) {
            this.parent = copyParent;
        }

        public List<MachineRecipe> getRecipes() {
            ArrayList out = Lists.newArrayListWithCapacity((int)this.recipeOwnerList.size());
            for (int i = 0; i < this.recipeOwnerList.size(); ++i) {
                ResourceLocation location = this.recipeOwnerList.get(i);
                MachineRecipe rec = new MachineRecipe(this.parent.recipeFilePath + "_sub_" + i, new ResourceLocation(this.parent.registryName.func_110624_b(), this.parent.registryName.func_110623_a() + "_sub_" + i), location, this.parent.tickTime, this.parent.configuredPriority);
                for (ComponentRequirement req : this.parent.recipeRequirements) {
                    rec.recipeRequirements.add(req.deepCopy());
                }
                out.add(rec);
            }
            return out;
        }
    }
}

