/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.types;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.requirements.RequirementItem;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.util.nbt.NBTJsonDeserializer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ComponentItem
extends ComponentType<RequirementItem> {
    @Override
    @Nonnull
    public String getRegistryName() {
        return "item";
    }

    @Override
    @Nullable
    public String requiresModid() {
        return null;
    }

    @Override
    @Nonnull
    public RequirementItem provideComponent(MachineComponent.IOType machineIoType, JsonObject jsonObject) {
        RequirementItem req;
        ResourceLocation res;
        if (!(jsonObject.has("item") && jsonObject.get("item").isJsonPrimitive() && jsonObject.get("item").getAsJsonPrimitive().isString())) {
            throw new JsonParseException("The ComponentType 'item' expects an 'item'-entry that defines the item!");
        }
        String itemDefinition = jsonObject.getAsJsonPrimitive("item").getAsString();
        int meta = 0;
        int indexMeta = itemDefinition.indexOf(64);
        if (indexMeta != -1 && indexMeta != itemDefinition.length() - 1) {
            try {
                meta = Integer.parseInt(itemDefinition.substring(indexMeta + 1));
            }
            catch (NumberFormatException exc) {
                throw new JsonParseException("Expected a metadata number, got " + itemDefinition.substring(indexMeta + 1), (Throwable)exc);
            }
            itemDefinition = itemDefinition.substring(0, indexMeta);
        }
        int amount = 1;
        if (jsonObject.has("amount")) {
            if (!jsonObject.get("amount").isJsonPrimitive() || !jsonObject.getAsJsonPrimitive("amount").isNumber()) {
                throw new JsonParseException("'amount', if defined, needs to be a amount-number!");
            }
            amount = MathHelper.func_76125_a((int)jsonObject.getAsJsonPrimitive("amount").getAsInt(), (int)1, (int)64);
        }
        if ((res = new ResourceLocation(itemDefinition)).func_110624_b().equalsIgnoreCase("any") && res.func_110623_a().equalsIgnoreCase("fuel")) {
            if (machineIoType == MachineComponent.IOType.OUTPUT) {
                throw new JsonParseException("You cannot define 'fuel' as item output! Offending item-output entry: " + res.toString());
            }
            if (!(jsonObject.has("time") && jsonObject.get("time").isJsonPrimitive() && jsonObject.get("time").getAsJsonPrimitive().isNumber())) {
                throw new JsonParseException("If you define any:fuel as item input, you have to define the burntime required in total in the 'time' entry alongside the 'item' entry!");
            }
            int burntime = jsonObject.getAsJsonPrimitive("time").getAsInt();
            req = new RequirementItem(machineIoType, burntime);
        } else if (res.func_110624_b().equalsIgnoreCase("ore")) {
            req = new RequirementItem(machineIoType, itemDefinition.substring(4), amount);
        } else {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(res);
            if (item == null || item == Items.field_190931_a) {
                throw new JsonParseException("Couldn't find item with registryName '" + res.toString() + "' !");
            }
            ItemStack result = meta > 0 ? new ItemStack(item, amount, meta) : new ItemStack(item, amount);
            req = new RequirementItem(machineIoType, result);
        }
        if (jsonObject.has("chance")) {
            if (!jsonObject.get("chance").isJsonPrimitive() || !jsonObject.getAsJsonPrimitive("chance").isNumber()) {
                throw new JsonParseException("'chance', if defined, needs to be a chance-number between 0 and 1!");
            }
            float chance = jsonObject.getAsJsonPrimitive("chance").getAsFloat();
            if (chance >= 0.0f && chance <= 1.0f) {
                req.setChance(chance);
            }
        }
        if (jsonObject.has("nbt")) {
            if (!jsonObject.has("nbt") || !jsonObject.get("nbt").isJsonObject()) {
                throw new JsonParseException("The ComponentType 'nbt' expects a json compound that defines the NBT tag!");
            }
            String nbtString = jsonObject.getAsJsonObject("nbt").toString();
            try {
                req.tag = NBTJsonDeserializer.deserialize(nbtString);
            }
            catch (NBTException exc) {
                throw new JsonParseException("Error trying to parse NBTTag! Rethrowing exception...", (Throwable)exc);
            }
            if (jsonObject.has("nbt-display")) {
                if (!jsonObject.has("nbt-display") || !jsonObject.get("nbt-display").isJsonObject()) {
                    throw new JsonParseException("The ComponentType 'nbt-display' expects a json compound that defines the NBT tag meant to be used for displaying!");
                }
                String nbtDisplayString = jsonObject.getAsJsonObject("nbt-display").toString();
                try {
                    req.previewDisplayTag = NBTJsonDeserializer.deserialize(nbtDisplayString);
                }
                catch (NBTException exc) {
                    throw new JsonParseException("Error trying to parse NBTTag! Rethrowing exception...", (Throwable)exc);
                }
            } else {
                req.previewDisplayTag = req.tag.func_74737_b();
            }
        }
        return req;
    }
}

