/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.util.HybridGasTank;
import hellfirepvp.modularmachinery.common.util.HybridTank;
import hellfirepvp.modularmachinery.common.util.IOInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Optional;

public class CopyHandlerHelper {
    public static HybridTank copyTank(HybridTank tank) {
        NBTTagCompound cmp = new NBTTagCompound();
        tank.writeToNBT(cmp);
        if (Mods.MEKANISM.isPresent()) {
            CopyHandlerHelper.writeGasTag(tank, cmp);
        }
        HybridTank newTank = new HybridTank(tank.getCapacity());
        if (Mods.MEKANISM.isPresent()) {
            newTank = CopyHandlerHelper.buildMekGasTank(tank.getCapacity());
        }
        newTank.readFromNBT(cmp);
        if (Mods.MEKANISM.isPresent()) {
            CopyHandlerHelper.readGasTag(newTank, cmp);
        }
        return newTank;
    }

    @Optional.Method(modid="mekanism")
    private static HybridTank buildMekGasTank(int capacity) {
        return new HybridGasTank(capacity);
    }

    @Optional.Method(modid="mekanism")
    private static void writeGasTag(HybridTank tank, NBTTagCompound compound) {
        if (tank instanceof HybridGasTank) {
            ((HybridGasTank)tank).writeGasToNBT(compound);
        }
    }

    @Optional.Method(modid="mekanism")
    private static void readGasTag(HybridTank tank, NBTTagCompound compound) {
        if (tank instanceof HybridGasTank) {
            ((HybridGasTank)tank).readGasFromNBT(compound);
        }
    }

    public static IOInventory copyInventory(IOInventory inventory) {
        return IOInventory.deserialize(inventory.getOwner(), inventory.writeNBT());
    }
}

