/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import hellfirepvp.modularmachinery.common.util.HybridTank;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;

public class HybridGasTank
extends HybridTank
implements IGasHandler {
    @Nullable
    protected GasStack gas;

    public HybridGasTank(int capacity) {
        super(capacity);
    }

    public void setFluid(@Nullable FluidStack fluid) {
        super.setFluid(fluid);
        if (this.getFluid() != null) {
            this.setGas(null);
        }
    }

    public int fillInternal(FluidStack resource, boolean doFill) {
        if (this.getGas() != null && this.getGas().amount > 0) {
            return 0;
        }
        return super.fillInternal(resource, doFill);
    }

    @Nullable
    public FluidStack drainInternal(int maxDrain, boolean doDrain) {
        if (this.getGas() != null && this.getGas().amount > 0) {
            return null;
        }
        return super.drainInternal(maxDrain, doDrain);
    }

    @Nullable
    public FluidStack drainInternal(FluidStack resource, boolean doDrain) {
        if (this.getGas() != null && this.getGas().amount > 0) {
            return null;
        }
        return super.drainInternal(resource, doDrain);
    }

    public void setGas(@Nullable GasStack stack) {
        if (stack != null) {
            this.gas = stack.copy();
            this.setFluid(null);
        } else {
            this.gas = null;
        }
    }

    @Nullable
    public GasStack getGas() {
        return this.gas;
    }

    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (stack == null || stack.amount <= 0) {
            return 0;
        }
        if (this.fluid != null && this.fluid.amount > 0) {
            return 0;
        }
        if (!doTransfer) {
            if (this.getGas() == null) {
                return Math.min(this.capacity, stack.amount);
            }
            if (!this.getGas().isGasEqual(stack)) {
                return 0;
            }
            return Math.min(this.capacity - this.getGas().amount, stack.amount);
        }
        if (this.getGas() == null) {
            this.setGas(new GasStack(stack.getGas(), Math.min(this.capacity, stack.amount)));
            this.onContentsChanged();
            return this.getGas().amount;
        }
        if (!this.getGas().isGasEqual(stack)) {
            return 0;
        }
        int filled = this.capacity - this.getGas().amount;
        if (this.getGas().amount < filled) {
            this.getGas().amount += stack.amount;
            filled = stack.amount;
        } else {
            this.getGas().amount = this.capacity;
        }
        this.onContentsChanged();
        return filled;
    }

    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.getGas() == null || amount <= 0) {
            return null;
        }
        if (this.getFluid() != null && this.getFluid().amount > 0) {
            return null;
        }
        int drained = amount;
        if (this.getGas().amount < drained) {
            drained = this.getGas().amount;
        }
        GasStack stack = new GasStack(this.getGas().getGas(), drained);
        if (doTransfer) {
            this.getGas().amount -= drained;
            if (this.getGas().amount <= 0) {
                this.setGas(null);
            }
            this.onContentsChanged();
        }
        return stack;
    }

    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return super.canFill();
    }

    public boolean canDrawGas(EnumFacing side, Gas type) {
        return super.canDrain();
    }

    public void readGasFromNBT(NBTTagCompound nbt) {
        NBTTagCompound subGas = nbt.func_74775_l("gasTag");
        if (subGas.func_186856_d() > 0) {
            if (!subGas.func_74764_b("Empty")) {
                this.setGas(GasStack.readFromNBT((NBTTagCompound)subGas));
            } else {
                this.setGas(null);
            }
        } else {
            this.setGas(null);
        }
    }

    public void writeGasToNBT(NBTTagCompound nbt) {
        NBTTagCompound subGas = new NBTTagCompound();
        if (this.gas != null) {
            this.gas.write(subGas);
        } else {
            subGas.func_74778_a("Empty", "");
        }
        nbt.func_74782_a("gasTag", (NBTBase)subGas);
    }
}

