/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.clientinspector;

import com.google.inject.Inject;
import io.github.aquerr.clientinspector.config.Config;
import io.github.aquerr.clientinspector.inspector.Inspector;
import io.github.aquerr.clientinspector.listener.PlayerConnectListener;
import io.github.aquerr.clientinspector.log.LogHandler;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandManager;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.plugin.Plugin;

@Plugin(id="clientinspector", name="Client Inspector", version="1.0.0", description="A plugin that inspects connecting players data and executes specified commands on them", authors={"Aquerr/Nerdi"}, url="https://github.com/Aquerr/ClientInspector")
public class ClientInspector {
    public static final String ID = "clientinspector";
    public static final String NAME = "Client Inspector";
    public static final String DESCRIPTION = "A plugin that inspects connecting players data and executes specified commands on them";
    public static final String VERSION = "1.0.0";
    public static final String URL = "https://github.com/Aquerr/ClientInspector";
    private static ClientInspector plugin;
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path configDir;
    @Inject
    private Logger logger;
    private Config config;
    private Inspector inspector;
    private LogHandler logHandler;

    public static ClientInspector getInstance() {
        return plugin;
    }

    @Listener
    public void onServerInit(GameInitializationEvent event) {
        plugin = this;
        this.logger.info("Initializing Client Inspector");
        this.config = Config.createConfig(this.configDir);
        this.logHandler = new LogHandler(this.configDir);
        this.inspector = new Inspector(this.config, this.logHandler);
        this.registerCommands();
        this.registerListeners();
        this.logger.info("Plugin load completed!");
    }

    @Listener
    public void onServerReload(GameReloadEvent event) {
        this.config.reload();
    }

    public Config getConfig() {
        return this.config;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Path getConfigDir() {
        return this.configDir;
    }

    public Inspector getInspector() {
        return this.inspector;
    }

    public LogHandler getLogHandler() {
        return this.logHandler;
    }

    private void registerCommands() {
        CommandManager commandManager = Sponge.getCommandManager();
    }

    private void registerListeners() {
        EventManager eventManager = Sponge.getEventManager();
        eventManager.registerListeners((Object)this, (Object)new PlayerConnectListener(this));
    }
}

