/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.clientinspector.config;

import io.github.aquerr.clientinspector.ClientInspector;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.util.TypeTokens;

public class Config {
    private final HoconConfigurationLoader hoconConfigurationLoader;
    private ConfigurationNode configNode;
    private List<String> commandsToRun;
    private Set<String> modsToDetect;

    public static Config createConfig(Path configDir) {
        Path configPath = configDir.resolve("config.conf");
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
            Asset asset = Sponge.getAssetManager().getAsset((Object)ClientInspector.getInstance(), "config.conf").orElse(null);
            if (asset != null) {
                asset.copyToFile(configPath, false, true);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Config(configPath);
    }

    private Config(Path configPath) {
        this.hoconConfigurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(configPath)).build();
        this.reload();
    }

    public List<String> getCommandsToRun() {
        return this.commandsToRun;
    }

    public Set<String> getModsToDetect() {
        return this.modsToDetect;
    }

    public void reload() {
        try {
            this.configNode = this.hoconConfigurationLoader.load();
            this.commandsToRun = this.configNode.getNode(new Object[]{"commands-to-run"}).getList(TypeTokens.STRING_TOKEN, Collections.emptyList());
            this.modsToDetect = new HashSet<String>(this.configNode.getNode(new Object[]{"mods-to-detect"}).getList(TypeTokens.STRING_TOKEN, Collections.emptyList()));
        }
        catch (IOException | ObjectMappingException e) {
            e.printStackTrace();
        }
    }
}

