/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.clientinspector.inspector;

import io.github.aquerr.clientinspector.config.Config;
import io.github.aquerr.clientinspector.log.LogHandler;
import io.github.aquerr.clientinspector.util.ForgePlayerUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;

public class Inspector {
    private static final Logger LOGGER = LoggerFactory.getLogger(Inspector.class);
    private static final String PLAYER_PLACEHOLDER = "%PLAYER%";
    private final Config config;
    private final LogHandler logHandler;

    public Inspector(Config config, LogHandler logHandler) {
        this.config = config;
        this.logHandler = logHandler;
    }

    public void inspect(Player player) {
        LOGGER.info("Inspecting player " + player);
        Set<String> playerModsNames = ForgePlayerUtil.getPlayerMods(player);
        Set<String> modsNamesToDetect = this.config.getModsToDetect();
        HashSet<String> detectedModsNames = new HashSet<String>();
        for (String playerModName : playerModsNames) {
            for (String modNameToDetect : modsNamesToDetect) {
                Pattern pattern = Pattern.compile(modNameToDetect, 2);
                if (!pattern.matcher(playerModName).matches()) continue;
                detectedModsNames.add(playerModName);
            }
        }
        if (detectedModsNames.size() != 0) {
            CompletableFuture.runAsync(() -> {
                try {
                    this.logHandler.logPlayerWithMods(player, detectedModsNames);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            this.executeCommandsOnPlayer(player, this.config.getCommandsToRun());
        }
    }

    private void executeCommandsOnPlayer(Player player, List<String> commandsToRun) {
        for (String command : commandsToRun) {
            Sponge.getCommandManager().process((CommandSource)Sponge.getServer().getConsole(), command.replaceAll(PLAYER_PLACEHOLDER, player.getName()));
        }
    }
}

