/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.clientinspector.log;

import io.github.aquerr.clientinspector.util.ForgePlayerUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.entity.living.player.Player;

public class LogHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogHandler.class);
    private Path logsDirPath;

    public LogHandler(Path configDir) {
        this.logsDirPath = configDir.resolve("logs");
        try {
            Files.createDirectories(this.logsDirPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void logPlayerWithMods(Player player, Set<String> detectedModsNames) throws IOException {
        LOGGER.info("Logging player '" + player.getName() + "' with mods " + Arrays.toString(detectedModsNames.toArray()));
        Path logFilePath = this.logsDirPath.resolve("inspection-" + LocalDate.now().toString() + ".log");
        if (Files.notExists(logFilePath, new LinkOption[0])) {
            Files.createFile(logFilePath, new FileAttribute[0]);
        }
        Files.write(logFilePath, this.buildLogMessage(player, detectedModsNames).getBytes(), StandardOpenOption.APPEND);
    }

    private String buildLogMessage(Player player, Set<String> detectedModsNames) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(LocalTime.now().withNano(0).toString()).append("]").append(" Player ").append("[name=").append(player.getName()).append(", uuid=").append(player.getUniqueId().toString()).append("]").append(" connected from '").append(ForgePlayerUtil.getIpAddress(player)).append("'").append(" with mods ").append(Arrays.toString(detectedModsNames.toArray())).append("\n");
        return stringBuilder.toString();
    }
}

