/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.commands.home;

import com.gmail.trentech.pjc.help.Help;
import com.gmail.trentech.pjp.data.Keys;
import com.gmail.trentech.pjp.data.mutable.HomeData;
import com.gmail.trentech.pjp.portal.Portal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;

public class CMDRename
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Help help = (Help)Help.get((String)"home rename").get();
        if (args.hasAny("help")) {
            help.execute(src);
            return CommandResult.empty();
        }
        if (!(src instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Must be a player"}));
        }
        Player player = (Player)src;
        if (!args.hasAny("oldName")) {
            throw new CommandException(Text.builder().onClick((ClickAction)TextActions.executeCallback((Consumer)help.execute())).append(new Text[]{help.getUsageText()}).build(), false);
        }
        String oldName = ((String)args.getOne("oldName").get()).toLowerCase();
        Map<String, Portal> list = new HashMap();
        Optional optionalList = player.get(Keys.PORTALS);
        if (optionalList.isPresent()) {
            list = (Map)optionalList.get();
        }
        if (!list.containsKey(oldName)) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, oldName, " does not exist"}));
        }
        Portal.Local local = (Portal.Local)list.get(oldName);
        if (!args.hasAny("newName")) {
            throw new CommandException(Text.builder().onClick((ClickAction)TextActions.executeCallback((Consumer)help.execute())).append(new Text[]{help.getUsageText()}).build(), false);
        }
        String newName = ((String)args.getOne("newName").get()).toLowerCase();
        if (list.containsKey(newName)) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, newName, " already exists"}), false);
        }
        list.remove(oldName);
        list.put(newName, local);
        DataTransactionResult result = player.offer((ValueContainer)new HomeData(list));
        if (!result.isSuccessful()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Could not rename ", oldName}), false);
        }
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Home renamed to ", newName}));
        return CommandResult.success();
    }
}

