/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.portal.features;

import com.flowpowered.math.vector.Vector3d;
import com.gmail.trentech.pjp.data.DataQueries;
import java.io.IOException;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataTranslators;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class Coordinate
implements DataSerializable {
    private World world;
    private Optional<Vector3d> vector3d = Optional.empty();
    private Preset preset = Preset.NONE;

    public Coordinate(World world, Vector3d vector3d) {
        this.world = world;
        this.vector3d = Optional.of(vector3d);
    }

    public Coordinate(World world, Preset preset) {
        this.world = world;
        this.preset = preset;
    }

    public Coordinate(Location<World> location) {
        this.world = (World)location.getExtent();
        this.vector3d = Optional.of(location.getPosition());
    }

    public World getWorld() {
        return this.world;
    }

    public Preset getPreset() {
        return this.preset;
    }

    public Optional<Location<World>> getLocation() {
        if (this.vector3d.isPresent()) {
            return Optional.of(new Location((Extent)this.world, this.vector3d.get()));
        }
        return Optional.of(this.world.getSpawnLocation());
    }

    public int getContentVersion() {
        return 0;
    }

    public DataContainer toContainer() {
        DataContainer dataContainer = DataContainer.createNew().set(DataQueries.WORLD, (Object)this.world.getName()).set(DataQueries.PRESET, (Object)this.preset.getName());
        if (this.vector3d.isPresent()) {
            dataContainer.set(DataQueries.VECTOR3D, (Object)DataTranslators.VECTOR_3_D.translate((Object)this.vector3d.get()));
        }
        return dataContainer;
    }

    public static String serialize(Location<World> location) {
        try {
            return DataFormats.JSON.write((DataView)new Coordinate(location).toContainer());
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public static Optional<Location<World>> deserialize(String coordinate) {
        try {
            return ((Coordinate)Sponge.getDataManager().deserialize(Coordinate.class, (DataView)DataFormats.JSON.read(coordinate)).get()).getLocation();
        }
        catch (IOException | InvalidDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static enum Preset {
        RANDOM("random"),
        BED("bed"),
        LAST_LOCATION("last_location"),
        NONE("none");

        private final String name;

        private Preset(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Preset get(String name) {
            Preset[] presets;
            for (Preset preset : presets = Preset.values()) {
                if (!preset.getName().equals(name.toLowerCase())) continue;
                return preset;
            }
            return null;
        }
    }

    public static class Builder
    extends AbstractDataBuilder<Coordinate> {
        public Builder() {
            super(Coordinate.class, 0);
        }

        protected Optional<Coordinate> buildContent(DataView container) throws InvalidDataException {
            if (container.contains(DataQueries.WORLD)) {
                Optional optionalWorld = Sponge.getServer().getWorld((String)container.getString(DataQueries.WORLD).get());
                if (!optionalWorld.isPresent()) {
                    return Optional.empty();
                }
                World world = (World)optionalWorld.get();
                if (container.contains(DataQueries.VECTOR3D)) {
                    Vector3d vector3d = (Vector3d)DataTranslators.VECTOR_3_D.translate((DataView)container.getView(DataQueries.VECTOR3D).get());
                    return Optional.of(new Coordinate(world, vector3d));
                }
                Preset preset = container.contains(DataQueries.RANDOM) ? (((Boolean)container.getBoolean(DataQueries.RANDOM).get()).booleanValue() ? Preset.RANDOM : (((Boolean)container.getBoolean(DataQueries.BED_RESPAWN).get()).booleanValue() ? Preset.BED : Preset.NONE)) : Preset.get((String)container.getString(DataQueries.PRESET).get());
                return Optional.of(new Coordinate(world, preset));
            }
            return Optional.empty();
        }
    }
}

