/*
 * Decompiled with CFR 0.152.
 */
package io.github.zerthick.coloranvil;

import com.google.inject.Inject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.api.item.inventory.slot.InputSlot;
import org.spongepowered.api.item.inventory.slot.OutputSlot;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.text.translation.Translation;

@Plugin(id="coloranvil", name="ColorAnvil", description="Name Items With Color!", authors={"Zerthick"})
public class ColorAnvil {
    @Inject
    private Logger logger;
    @Inject
    private PluginContainer instance;
    private Pattern formatCodePattern = Pattern.compile("&([a-z0-9])");

    @Listener
    public void onServerStart(GameStartedServerEvent event) {
        this.logger.info(this.instance.getName() + " version " + this.instance.getVersion().orElse("") + " enabled!");
    }

    @Listener
    public void onItemForge(ClickInventoryEvent event, @First Player player, @Getter(value="getTargetInventory") Inventory inventory) {
        if (inventory.getArchetype() == InventoryArchetypes.ANVIL && player.hasPermission("coloranvil.use")) {
            event.getTransactions().forEach(slotTransaction -> {
                if (slotTransaction.getSlot() instanceof OutputSlot && ((ItemStackSnapshot)slotTransaction.getOriginal()).equals(event.getCursorTransaction().getDefault())) {
                    ItemStack originalStack = ((ItemStackSnapshot)slotTransaction.getOriginal()).createStack();
                    if (originalStack.getType() != ItemTypes.AIR) {
                        Text itemName = (Text)originalStack.get(Keys.DISPLAY_NAME).orElse(Text.of((Translation)originalStack.getTranslation(), (Object[])new Object[0]));
                        String itemNamePlain = itemName.toPlain();
                        Matcher matcher = this.formatCodePattern.matcher(itemNamePlain);
                        StringBuffer sb = new StringBuffer();
                        while (matcher.find()) {
                            if (player.hasPermission("coloranvil.color." + matcher.group(1))) continue;
                            matcher.appendReplacement(sb, "");
                        }
                        matcher.appendTail(sb);
                        itemNamePlain = sb.toString();
                        itemName = TextSerializers.FORMATTING_CODE.deserialize(itemNamePlain);
                        originalStack.offer(Keys.DISPLAY_NAME, (Object)itemName);
                        event.getCursorTransaction().setCustom((DataSerializable)originalStack.createSnapshot());
                    }
                } else if (slotTransaction.getSlot() instanceof InputSlot && ((ItemStackSnapshot)slotTransaction.getFinal()).equals(event.getCursorTransaction().getOriginal())) {
                    slotTransaction.getSlot().getProperties(SlotIndex.class).stream().findFirst().ifPresent(slotIndex -> {
                        if (slotIndex.getValue() != null && (Integer)slotIndex.getValue() == 0) {
                            slotTransaction.getSlot().peek().ifPresent(itemStack -> {
                                Text itemName = (Text)itemStack.get(Keys.DISPLAY_NAME).orElse(Text.of((Translation)itemStack.getTranslation(), (Object[])new Object[0]));
                                String itemNameSerialized = TextSerializers.FORMATTING_CODE.serialize(itemName);
                                itemStack.offer(Keys.DISPLAY_NAME, (Object)Text.of((String)itemNameSerialized));
                                slotTransaction.setCustom(itemStack);
                            });
                        }
                    });
                }
            });
        }
    }
}

