/*
 * Decompiled with CFR 0.152.
 */
package me.runescapejon.enderegg;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import java.io.File;
import java.util.concurrent.TimeUnit;
import me.runescapejon.enderegg.Config;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.objectmapping.GuiceObjectMapperFactory;
import ninja.leaping.configurate.objectmapping.ObjectMapperFactory;
import org.slf4j.Logger;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.complex.EnderDragon;
import org.spongepowered.api.entity.living.complex.dragon.phase.EnderDragonPhaseTypes;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.world.World;

@Plugin(id="endereggdropper", name="EnderEggDropper", authors={"runescapejon"}, description="Place a dragon egg on top of the portal or have the dragon drop the once it's killed", version="1.1")
public class EnderEgg {
    public static EnderEgg instance;
    private EnderEgg plugin;
    private Logger logger;
    private Config configmsg;
    GuiceObjectMapperFactory factory;
    private final File configDirectory;
    String HeaderMessage = "Thank you for downloading and trying it out. Let me explain how this work please choose ONE option for the egg to drop or place. ONLY CHOOSE 1 because if you choose twice it will spawn the egg twice. If you choose to place the egg make sure that you have the correct height from the top of the portal. By default it's 70 because the egg can just fall into place";
    private Task task;

    @Inject
    public EnderEgg(Logger logger, @ConfigDir(sharedRoot=false) File configDir, GuiceObjectMapperFactory factory) {
        this.logger = logger;
        this.configDirectory = configDir;
        this.factory = factory;
        instance = this;
    }

    @Listener
    public void onPreInitializationEvent(GamePreInitializationEvent event) {
        this.plugin = this;
        this.loadConfig();
    }

    @Listener
    public void onGamePreInitialization(GamePreInitializationEvent event) {
    }

    public Logger getLogger() {
        return this.logger;
    }

    public GuiceObjectMapperFactory getFactory() {
        return this.factory;
    }

    public Config getCfg() {
        return this.configmsg;
    }

    @Listener
    public void onReload(GameReloadEvent event) {
        this.loadConfig();
    }

    public boolean loadConfig() {
        if (!this.plugin.getConfigDirectory().exists()) {
            this.plugin.getConfigDirectory().mkdirs();
        }
        try {
            File configFile = new File(this.getConfigDirectory(), "Config.conf");
            if (!configFile.exists()) {
                configFile.createNewFile();
                this.logger.info("Creating Config for EnderEggDropper");
            }
            HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(configFile)).build();
            CommentedConfigurationNode config = (CommentedConfigurationNode)loader.load(ConfigurationOptions.defaults().setHeader(this.HeaderMessage).setObjectMapperFactory((ObjectMapperFactory)this.plugin.getFactory()).setShouldCopyDefaults(true));
            this.configmsg = (Config)config.getValue(TypeToken.of(Config.class), (Object)new Config());
            loader.save((ConfigurationNode)config);
            return true;
        }
        catch (Exception error) {
            this.getLogger().error("coudnt make the config", (Throwable)error);
            return false;
        }
    }

    public File getConfigDirectory() {
        return this.configDirectory;
    }

    @Listener
    public void onEntityDeath(DestructEntityEvent.Death event) {
        Living entity = event.getTargetEntity();
        if (event.getTargetEntity() instanceof EnderDragon) {
            Living e = event.getTargetEntity();
            Vector3d position = e.getLocation().getPosition();
            World world = entity.getWorld();
            Entity itemEntity = world.createEntity(EntityTypes.ITEM, position);
            if (Config.DropDragonEgg) {
                Item items = (Item)itemEntity;
                ItemStack itemStack = ItemStack.builder().itemType(ItemTypes.DRAGON_EGG).quantity(1).build();
                items.offer(Keys.REPRESENTED_ITEM, (Object)itemStack.createSnapshot());
                world.spawnEntity((Entity)items);
            }
            if (Config.PlaceDragonEgg && EnderDragonPhaseTypes.DYING != null) {
                this.task = Task.builder().delay(15L, TimeUnit.SECONDS).execute(() -> {
                    event.getTargetEntity().getWorld().setBlock(0, Config.setHeight, 0, (BlockState)BlockState.builder().blockType(BlockTypes.DRAGON_EGG).build());
                    this.task.cancel();
                }).submit((Object)this);
            }
        }
    }
}

