/*
 * Decompiled with CFR 0.152.
 */
package kristi71111.chatcolor.commands;

import java.util.ArrayList;
import java.util.Objects;
import kristi71111.chatcolor.ChatColor;
import kristi71111.chatcolor.definitions.Helpers;
import kristi71111.chatcolor.definitions.Pagination;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.MetaNode;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.ProviderRegistration;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextTemplate;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.text.serializer.TextSerializers;

public class ChatColorCommand
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (!(src instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "You need to be a player to run this command!"}));
        }
        if (!args.getOne("color/clear").isPresent()) {
            TextColor[] textColors;
            ArrayList<Text> texts = new ArrayList<Text>();
            boolean found = false;
            for (TextColor color : textColors = new TextColor[]{TextColors.BLACK, TextColors.DARK_BLUE, TextColors.DARK_GREEN, TextColors.DARK_AQUA, TextColors.DARK_RED, TextColors.DARK_PURPLE, TextColors.GOLD, TextColors.GRAY, TextColors.DARK_GRAY, TextColors.BLUE, TextColors.GREEN, TextColors.AQUA, TextColors.RED, TextColors.LIGHT_PURPLE, TextColors.YELLOW, TextColors.WHITE}) {
                if (!src.hasPermission("chatcolor.color." + color.getName())) continue;
                found = true;
                LiteralText hover = Text.builder((String)"Click here to make your chat color permanently ").color(TextColors.GREEN).append(new Text[]{Text.builder((String)color.getId().replace("_", " ").toLowerCase()).color(color).build()}).append(new Text[]{Text.builder((String)"!").color(TextColors.GREEN).build()}).build();
                texts.add(Text.builder().append(new Text[]{Text.builder().color(color).style(new TextStyle[]{TextStyles.BOLD}).append(new Text[]{Text.of((String)(color.getId().replace("_", " ") + " - CLICK"))}).onClick((ClickAction)TextActions.runCommand((String)("/chatcolor " + color.getName()))).onHover((HoverAction)TextActions.showText((Text)hover)).build()}).build());
            }
            if (src.hasPermission("chatcolor.color.clear")) {
                found = true;
                texts.add(Text.builder().append(new Text[]{Text.builder().color(TextColors.WHITE).style(new TextStyle[]{TextStyles.BOLD}).append(new Text[]{Text.of((String)"CLEAR - CLICK")}).onClick((ClickAction)TextActions.runCommand((String)"/chatcolor clear")).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.GREEN, "Click here to clear your chat color!"}))).build()}).build());
            }
            if (!found) {
                texts.add(Text.builder().append(new Text[]{Text.builder().color(TextColors.RED).style(new TextStyle[]{TextStyles.BOLD}).append(new Text[]{Text.of((String)" You don't have any of the required permissions to set a permanent chat color!")}).build()}).build());
            }
            PaginationList paginationlist = new Pagination().getPaginationService().builder().footer(Text.of((Object[])new Object[]{TextColors.GOLD, TextStyles.BOLD, "Made by kristi71111"})).padding((Text)Text.of((String)"-")).title(TextTemplate.of((Object[])new Object[]{TextColors.RED, TextStyles.BOLD, "{ChatColor v" + ChatColor.version + "}"}).apply().build()).contents(texts).build();
            paginationlist.sendTo((MessageReceiver)src);
        } else {
            MetaNode node;
            LuckPerms luckPermsAPI = (LuckPerms)((ProviderRegistration)Sponge.getServiceManager().getRegistration(LuckPerms.class).get()).getProvider();
            User LPUser = Objects.requireNonNull(luckPermsAPI.getUserManager().getUser(((Player)src).getUniqueId()));
            String selected = ChatColor.colors.get(args.getOne("color/clear").get());
            Object o = args.getOne("global").orElse(null);
            if (o != null && !src.hasPermission("chatcolor.set.global")) {
                throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, " You do not have permission to use the global argument!"}));
            }
            if (!src.hasPermission("chatcolor.color." + args.getOne("color/clear").get())) {
                throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, " You do not have permission to use this chat color or the clear argument!"}));
            }
            boolean AlreadyHasSet = false;
            if (LPUser.getCachedData().getMetaData().getMeta().containsKey("chatcolor")) {
                AlreadyHasSet = true;
            }
            if (selected.equalsIgnoreCase("clear")) {
                if (o == null || !((Boolean)o).booleanValue()) {
                    Helpers.RemoveAllServer(LPUser, luckPermsAPI, AlreadyHasSet);
                } else {
                    Helpers.RemoveAllGlobal(LPUser, AlreadyHasSet);
                }
                luckPermsAPI.getUserManager().saveUser(LPUser);
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, " All cleared and ready to go!"}));
                return CommandResult.success();
            }
            if (o == null || !((Boolean)o).booleanValue()) {
                Helpers.RemoveAllServer(LPUser, luckPermsAPI, AlreadyHasSet);
                node = (MetaNode)((MetaNode.Builder)MetaNode.builder().key("chatcolor").value(selected).withContext("server", luckPermsAPI.getServerName())).build();
            } else {
                Helpers.RemoveAllGlobal(LPUser, AlreadyHasSet);
                node = (MetaNode)MetaNode.builder().key("chatcolor").value(selected).build();
            }
            LPUser.data().add((Node)node);
            luckPermsAPI.getUserManager().saveUser(LPUser);
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, " Your chat color is now ", TextSerializers.FORMATTING_CODE.deserialize("&" + selected + "cute like you ;)")}));
        }
        return CommandResult.success();
    }
}

