/*
 * Decompiled with CFR 0.152.
 */
package de.randombyte.unity.commands;

import de.randombyte.unity.commands.UtilsKt;
import de.randombyte.unity.config.Config;
import de.randombyte.unity.config.ConfigAccessor;
import de.randombyte.unity.shaded.kosp.PlayerExecutedCommand;
import de.randombyte.unity.shaded.kosp.extensions.StringsKt;
import de.randombyte.unity.shaded.kotlin.Metadata;
import de.randombyte.unity.shaded.kotlin.TuplesKt;
import de.randombyte.unity.shaded.kotlin.Unit;
import de.randombyte.unity.shaded.kotlin.collections.CollectionsKt;
import de.randombyte.unity.shaded.kotlin.collections.MapsKt;
import de.randombyte.unity.shaded.kotlin.jvm.functions.Function0;
import de.randombyte.unity.shaded.kotlin.jvm.functions.Function2;
import de.randombyte.unity.shaded.kotlin.jvm.internal.Intrinsics;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u00060\u0005\u00126\u0010\t\u001a2\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\n\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R)\u0010\u0004\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014RA\u0010\t\u001a2\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lde/randombyte/unity/commands/AcceptRequestCommand;", "Lde/randombyte/unity/shaded/kosp/PlayerExecutedCommand;", "configAccessor", "Lde/randombyte/unity/config/ConfigAccessor;", "getRequests", "Lde/randombyte/unity/shaded/kotlin/Function0;", "", "Ljava/util/UUID;", "", "removeRequest", "Lde/randombyte/unity/shaded/kotlin/Function2;", "Lde/randombyte/unity/shaded/kotlin/ParameterName;", "name", "requester", "requestee", "", "(Lde/randombyte/unity/config/ConfigAccessor;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function2;)V", "getConfigAccessor", "()Lde/randombyte/unity/config/ConfigAccessor;", "getGetRequests", "()Lkotlin/jvm/functions/Function0;", "getRemoveRequest", "()Lkotlin/jvm/functions/Function2;", "executedByPlayer", "Lorg/spongepowered/api/command/CommandResult;", "player", "Lorg/spongepowered/api/entity/living/player/Player;", "args", "Lorg/spongepowered/api/command/args/CommandContext;", "unity"})
public final class AcceptRequestCommand
extends PlayerExecutedCommand {
    @NotNull
    private final ConfigAccessor configAccessor;
    @NotNull
    private final Function0<Map<UUID, List<UUID>>> getRequests;
    @NotNull
    private final Function2<UUID, UUID, Unit> removeRequest;

    @Override
    @NotNull
    public CommandResult executedByPlayer(@NotNull Player player, @NotNull CommandContext args) {
        Text broadcastMessage;
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(args, "args");
        Object t = args.getOne("player").get();
        Intrinsics.checkExpressionValueIsNotNull(t, "args.getOne<Player>(Unity.PLAYER_ARG).get()");
        Player requester = (Player)t;
        if (!UtilsKt.checkRequester(requester, player, this.getRequests.invoke())) {
            throw (Throwable)new CommandException(StringsKt.toText("You don't have a request from '" + requester.getName() + "'!"));
        }
        Config config = this.configAccessor.get();
        UtilsKt.requireSingle(player, requester, config.getUnities());
        UUID uUID = requester.getUniqueId();
        Intrinsics.checkExpressionValueIsNotNull(uUID, "requester.uniqueId");
        UUID uUID2 = player.getUniqueId();
        Intrinsics.checkExpressionValueIsNotNull(uUID2, "player.uniqueId");
        this.removeRequest.invoke(uUID, uUID2);
        Collection collection = config.getUnities();
        UUID uUID3 = requester.getUniqueId();
        Intrinsics.checkExpressionValueIsNotNull(uUID3, "requester.uniqueId");
        UUID uUID4 = player.getUniqueId();
        Intrinsics.checkExpressionValueIsNotNull(uUID4, "player.uniqueId");
        Date date = Date.from(Instant.now());
        Intrinsics.checkExpressionValueIsNotNull(date, "Date.from(Instant.now())");
        Config newConfig = Config.copy$default(config, CollectionsKt.plus(collection, new Config.Unity(uUID3, uUID4, null, date, 4, null)), null, null, null, false, false, 62, null);
        this.configAccessor.set(newConfig);
        Text text = broadcastMessage = config.getTexts().getUnityBroadcast().apply(MapsKt.mapOf(TuplesKt.to("member1", requester.getName()), TuplesKt.to("member2", player.getName()))).build();
        Intrinsics.checkExpressionValueIsNotNull(text, "broadcastMessage");
        UtilsKt.broadcastIfNotEmpty(text);
        CommandResult commandResult = CommandResult.success();
        Intrinsics.checkExpressionValueIsNotNull(commandResult, "CommandResult.success()");
        return commandResult;
    }

    @NotNull
    public final ConfigAccessor getConfigAccessor() {
        return this.configAccessor;
    }

    @NotNull
    public final Function0<Map<UUID, List<UUID>>> getGetRequests() {
        return this.getRequests;
    }

    @NotNull
    public final Function2<UUID, UUID, Unit> getRemoveRequest() {
        return this.removeRequest;
    }

    public AcceptRequestCommand(@NotNull ConfigAccessor configAccessor2, @NotNull Function0<? extends Map<UUID, ? extends List<UUID>>> getRequests, @NotNull Function2<? super UUID, ? super UUID, Unit> removeRequest2) {
        Intrinsics.checkParameterIsNotNull(configAccessor2, "configAccessor");
        Intrinsics.checkParameterIsNotNull(getRequests, "getRequests");
        Intrinsics.checkParameterIsNotNull(removeRequest2, "removeRequest");
        this.configAccessor = configAccessor2;
        this.getRequests = getRequests;
        this.removeRequest = removeRequest2;
    }
}

