/*
 * Decompiled with CFR 0.152.
 */
package de.randombyte.unity.commands;

import de.randombyte.unity.commands.UtilsKt;
import de.randombyte.unity.config.Config;
import de.randombyte.unity.config.ConfigAccessor;
import de.randombyte.unity.shaded.kosp.PlayerExecutedCommand;
import de.randombyte.unity.shaded.kosp.extensions.StringsKt;
import de.randombyte.unity.shaded.kosp.extensions.TextsKt;
import de.randombyte.unity.shaded.kotlin.Metadata;
import de.randombyte.unity.shaded.kotlin.TuplesKt;
import de.randombyte.unity.shaded.kotlin.collections.MapsKt;
import de.randombyte.unity.shaded.kotlin.jvm.functions.Function2;
import de.randombyte.unity.shaded.kotlin.jvm.internal.Intrinsics;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.TextAction;
import org.spongepowered.api.text.action.TextActions;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00126\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016RA\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lde/randombyte/unity/commands/RequestUnityCommand;", "Lde/randombyte/unity/shaded/kosp/PlayerExecutedCommand;", "configAccessor", "Lde/randombyte/unity/config/ConfigAccessor;", "addRequest", "Lde/randombyte/unity/shaded/kotlin/Function2;", "Ljava/util/UUID;", "Lde/randombyte/unity/shaded/kotlin/ParameterName;", "name", "requester", "requestee", "", "(Lde/randombyte/unity/config/ConfigAccessor;Lkotlin/jvm/functions/Function2;)V", "getAddRequest", "()Lkotlin/jvm/functions/Function2;", "getConfigAccessor", "()Lde/randombyte/unity/config/ConfigAccessor;", "executedByPlayer", "Lorg/spongepowered/api/command/CommandResult;", "player", "Lorg/spongepowered/api/entity/living/player/Player;", "args", "Lorg/spongepowered/api/command/args/CommandContext;", "unity"})
public final class RequestUnityCommand
extends PlayerExecutedCommand {
    @NotNull
    private final ConfigAccessor configAccessor;
    @NotNull
    private final Function2<UUID, UUID, Boolean> addRequest;

    @Override
    @NotNull
    public CommandResult executedByPlayer(@NotNull Player player, @NotNull CommandContext args) {
        Text requestMessage;
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(args, "args");
        Object t = args.getOne("player").get();
        Intrinsics.checkExpressionValueIsNotNull(t, "args.getOne<Player>(Unity.PLAYER_ARG).get()");
        Player requestee = (Player)t;
        Config config = this.configAccessor.get();
        UtilsKt.requireSingle(player, requestee, config.getUnities());
        if (Intrinsics.areEqual(requestee.getUniqueId(), player.getUniqueId())) {
            throw (Throwable)new CommandException(StringsKt.toText("Choose another player!"));
        }
        UUID uUID = player.getUniqueId();
        Intrinsics.checkExpressionValueIsNotNull(uUID, "player.uniqueId");
        UUID uUID2 = requestee.getUniqueId();
        Intrinsics.checkExpressionValueIsNotNull(uUID2, "requestee.uniqueId");
        if (!this.addRequest.invoke(uUID, uUID2).booleanValue()) {
            throw (Throwable)new CommandException(StringsKt.toText("You already sent a request to '" + requestee.getName() + "'!"));
        }
        Text acceptRequest = TextsKt.action(config.getTexts().getAcceptRequestAction(), (TextAction)TextActions.runCommand((String)("/unity accept " + player.getName())));
        Text declineRequest = TextsKt.action(config.getTexts().getDeclineRequestAction(), (TextAction)TextActions.runCommand((String)("/unity decline " + player.getName())));
        Text text = requestMessage = config.getTexts().getGotRequest().apply(MapsKt.mapOf(TuplesKt.to("requester", player.getName()))).build();
        Intrinsics.checkExpressionValueIsNotNull(text, "requestMessage");
        UtilsKt.sendMessageIfNotEmpty(requestee, TextsKt.plus(TextsKt.plus(TextsKt.plus(TextsKt.plus(text, " "), acceptRequest), " "), declineRequest));
        Text text2 = config.getTexts().getSentRequest().apply(MapsKt.mapOf(TuplesKt.to("requestee", requestee.getName()))).build();
        Intrinsics.checkExpressionValueIsNotNull(text2, "config.texts.sentRequest\u2026 requestee.name)).build()");
        UtilsKt.sendMessageIfNotEmpty(player, text2);
        Text text3 = config.getTexts().getRequestBroadcast().apply(MapsKt.mapOf(TuplesKt.to("requester", player.getName()), TuplesKt.to("requestee", requestee.getName()))).build();
        Intrinsics.checkExpressionValueIsNotNull(text3, "config.texts.requestBroa\u2026e.name\n        )).build()");
        UtilsKt.broadcastIfNotEmpty(text3);
        CommandResult commandResult = CommandResult.success();
        Intrinsics.checkExpressionValueIsNotNull(commandResult, "CommandResult.success()");
        return commandResult;
    }

    @NotNull
    public final ConfigAccessor getConfigAccessor() {
        return this.configAccessor;
    }

    @NotNull
    public final Function2<UUID, UUID, Boolean> getAddRequest() {
        return this.addRequest;
    }

    public RequestUnityCommand(@NotNull ConfigAccessor configAccessor2, @NotNull Function2<? super UUID, ? super UUID, Boolean> addRequest) {
        Intrinsics.checkParameterIsNotNull(configAccessor2, "configAccessor");
        Intrinsics.checkParameterIsNotNull(addRequest, "addRequest");
        this.configAccessor = configAccessor2;
        this.addRequest = addRequest;
    }
}

