/*
 * Decompiled with CFR 0.152.
 */
package de.randombyte.unity.commands;

import de.randombyte.unity.config.Config;
import de.randombyte.unity.shaded.kosp.extensions.StringsKt;
import de.randombyte.unity.shaded.kotlin.Metadata;
import de.randombyte.unity.shaded.kotlin.collections.CollectionsKt;
import de.randombyte.unity.shaded.kotlin.jvm.internal.Intrinsics;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a$\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a,\u0010\u000b\u001a\u00020\f*\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\t0\u000f\u001a\u001a\u0010\u0011\u001a\u0004\u0018\u00010\n*\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0012\u001a\u00020\u0010\u001a\u0018\u0010\u0013\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0012\u001a\u00020\u0010\u001a\u0012\u0010\u0014\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0015"}, d2={"broadcastIfNotEmpty", "", "text", "Lorg/spongepowered/api/text/Text;", "requireSingle", "commandSource", "Lorg/spongepowered/api/entity/living/player/Player;", "otherPlayer", "unities", "", "Lde/randombyte/unity/config/Config$Unity;", "checkRequester", "", "requestee", "requests", "", "Ljava/util/UUID;", "getUnity", "playerUuid", "isSingle", "sendMessageIfNotEmpty", "unity"})
public final class UtilsKt {
    public static final boolean checkRequester(@NotNull Player $receiver, @NotNull Player requestee, @NotNull Map<UUID, ? extends List<UUID>> requests) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(requestee, "requestee");
        Intrinsics.checkParameterIsNotNull(requests, "requests");
        if (Intrinsics.areEqual($receiver, requestee)) {
            return false;
        }
        List<UUID> list = requests.get(requestee.getUniqueId());
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List<UUID> requestsToPlayer = list;
        return requestsToPlayer.contains($receiver.getUniqueId());
    }

    public static final void requireSingle(@NotNull Player commandSource, @NotNull Player otherPlayer2, @NotNull List<Config.Unity> unities) {
        Intrinsics.checkParameterIsNotNull(commandSource, "commandSource");
        Intrinsics.checkParameterIsNotNull(otherPlayer2, "otherPlayer");
        Intrinsics.checkParameterIsNotNull(unities, "unities");
        List<Config.Unity> $receiver = unities;
        UUID uUID = commandSource.getUniqueId();
        Intrinsics.checkExpressionValueIsNotNull(uUID, "commandSource.uniqueId");
        if (!UtilsKt.isSingle($receiver, uUID)) {
            throw (Throwable)new CommandException(StringsKt.toText("You must be single to execute this command!"));
        }
        UUID uUID2 = otherPlayer2.getUniqueId();
        Intrinsics.checkExpressionValueIsNotNull(uUID2, "otherPlayer.uniqueId");
        if (!UtilsKt.isSingle($receiver, uUID2)) {
            throw (Throwable)new CommandException(StringsKt.toText('\'' + otherPlayer2.getName() + "' must be single to execute this command!"));
        }
    }

    @Nullable
    public static final Config.Unity getUnity(@NotNull List<Config.Unity> $receiver, @NotNull UUID playerUuid) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
            Intrinsics.checkParameterIsNotNull(playerUuid, "playerUuid");
            Iterable $receiver$iv = $receiver;
            for (Object element$iv : $receiver$iv) {
                Config.Unity $member1_member2 = (Config.Unity)element$iv;
                UUID member1 = $member1_member2.component1();
                UUID member2 = $member1_member2.component2();
                if (!(Intrinsics.areEqual(member1, playerUuid) || Intrinsics.areEqual(member2, playerUuid))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public static final boolean isSingle(@NotNull List<Config.Unity> $receiver, @NotNull UUID playerUuid) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(playerUuid, "playerUuid");
        return UtilsKt.getUnity($receiver, playerUuid) == null;
    }

    public static final void broadcastIfNotEmpty(@NotNull Text text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        if (!text.isEmpty()) {
            Server server = Sponge.getServer();
            Intrinsics.checkExpressionValueIsNotNull(server, "Sponge.getServer()");
            server.getBroadcastChannel().send(text);
        }
    }

    public static final void sendMessageIfNotEmpty(@NotNull Player $receiver, @NotNull Text text) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(text, "text");
        if (!text.isEmpty()) {
            $receiver.sendMessage(text);
        }
    }
}

