/*
 * Decompiled with CFR 0.152.
 */
package de.randombyte.unity.shaded.kosp.config.serializers.duration;

import com.google.common.reflect.TypeToken;
import de.randombyte.unity.shaded.kotlin.Metadata;
import de.randombyte.unity.shaded.kotlin.jvm.internal.Intrinsics;
import de.randombyte.unity.shaded.kotlin.text.MatchResult;
import de.randombyte.unity.shaded.kotlin.text.Regex;
import java.time.Duration;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\r\u001a\u00020\u00022\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\r\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013J$\u0010\u0014\u001a\u00020\u00152\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00022\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/randombyte/unity/shaded/kosp/config/serializers/duration/SimpleDurationTypeSerializer;", "Lninja/leaping/configurate/objectmapping/serialize/TypeSerializer;", "Ljava/time/Duration;", "()V", "DAY", "", "HOUR", "MINUTE", "REGEX", "Lde/randombyte/unity/shaded/kotlin/text/Regex;", "getREGEX", "()Lkotlin/text/Regex;", "SECOND", "deserialize", "type", "Lcom/google/common/reflect/TypeToken;", "node", "Lninja/leaping/configurate/ConfigurationNode;", "string", "", "serialize", "", "duration", "outputMilliseconds", "", "toLongOrZero", "", "kosp"})
public final class SimpleDurationTypeSerializer
implements TypeSerializer<Duration> {
    private static final int SECOND = 1000;
    private static final int MINUTE = 60;
    private static final int HOUR = 3600;
    private static final int DAY = 86400;
    @NotNull
    private static final Regex REGEX;
    public static final SimpleDurationTypeSerializer INSTANCE;

    @NotNull
    public final Regex getREGEX() {
        return REGEX;
    }

    @NotNull
    public Duration deserialize(@NotNull TypeToken<?> type, @NotNull ConfigurationNode node) {
        Intrinsics.checkParameterIsNotNull(type, "type");
        Intrinsics.checkParameterIsNotNull(node, "node");
        String string = node.getString();
        Intrinsics.checkExpressionValueIsNotNull(string, "node.string");
        return this.deserialize(string);
    }

    public void serialize(@NotNull TypeToken<?> type, @NotNull Duration duration, @NotNull ConfigurationNode node) {
        Intrinsics.checkParameterIsNotNull(type, "type");
        Intrinsics.checkParameterIsNotNull(duration, "duration");
        Intrinsics.checkParameterIsNotNull(node, "node");
        node.setValue((Object)SimpleDurationTypeSerializer.serialize$default(this, duration, false, 2, null));
    }

    @NotNull
    public final Duration deserialize(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "string");
        MatchResult matchResult = REGEX.matchEntire(string);
        if (matchResult == null) {
            throw (Throwable)new RuntimeException("Couldn't parse duration '" + string + "'!");
        }
        MatchResult result = matchResult;
        long days = this.toLongOrZero(result.getGroupValues().get(1));
        long hours = this.toLongOrZero(result.getGroupValues().get(2));
        long minutes = this.toLongOrZero(result.getGroupValues().get(3));
        long seconds = this.toLongOrZero(result.getGroupValues().get(4));
        long milliseconds = this.toLongOrZero(result.getGroupValues().get(5));
        Duration duration = Duration.ofDays(days).plusHours(hours).plusMinutes(minutes).plusSeconds(seconds).plusMillis(milliseconds);
        Intrinsics.checkExpressionValueIsNotNull(duration, "Duration.ofDays(days).pl\u2026.plusMillis(milliseconds)");
        return duration;
    }

    @NotNull
    public final String serialize(@NotNull Duration duration, boolean outputMilliseconds) {
        String string;
        int n;
        long l;
        Intrinsics.checkParameterIsNotNull(duration, "duration");
        long days = duration.getSeconds() / (long)86400;
        long hours = duration.getSeconds() % (long)86400 / (long)3600;
        long minutes = duration.getSeconds() % (long)86400 % (long)3600 / (long)60;
        long seconds = duration.getSeconds() % (long)86400 % (long)3600 % (long)60;
        int milliseconds = duration.getNano() / 1000000;
        StringBuilder sb = new StringBuilder();
        long $receiver = l = days;
        if ($receiver != 0L) {
            sb.append($receiver).append("d");
        }
        if (($receiver = (l = hours)) != 0L) {
            sb.append($receiver).append("h");
        }
        if (($receiver = (l = minutes)) != 0L) {
            sb.append($receiver).append("m");
        }
        if (($receiver = (l = seconds)) != 0L) {
            sb.append($receiver).append("s");
        }
        int $receiver2 = n = milliseconds;
        if (outputMilliseconds && $receiver2 != 0) {
            sb.append($receiver2).append("ms");
        }
        String string2 = string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "string");
        CharSequence charSequence = string2;
        return charSequence.length() > 0 ? string : "0s";
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String serialize$default(SimpleDurationTypeSerializer simpleDurationTypeSerializer, Duration duration, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return simpleDurationTypeSerializer.serialize(duration, bl);
    }

    private final long toLongOrZero(@NotNull String $receiver) {
        long l;
        CharSequence charSequence = $receiver;
        if (charSequence.length() == 0) {
            l = 0L;
        } else {
            charSequence = $receiver;
            l = Long.parseLong((String)charSequence);
        }
        return l;
    }

    private SimpleDurationTypeSerializer() {
    }

    static {
        SimpleDurationTypeSerializer simpleDurationTypeSerializer;
        INSTANCE = simpleDurationTypeSerializer = new SimpleDurationTypeSerializer();
        String string = "(?:(\\d+)d)?(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?(?:(\\d+)ms)?";
        REGEX = new Regex(string);
    }
}

