/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.realbench;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorkbenchTile
extends TileEntity {
    protected NonNullList<ItemStack> mCraftMatrix = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);

    public List<ItemStack> getCraftMatrixItems() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ItemStack stack : this.mCraftMatrix) {
            if (stack == null) continue;
            builder.add((Object)stack);
        }
        return builder.build();
    }

    private void writeSlots(NBTTagCompound nbt) {
        nbt.func_74768_a("Capacity", this.mCraftMatrix.size());
        for (int i = 0; i < 9; ++i) {
            if (this.mCraftMatrix.get(i) == ItemStack.field_190927_a) {
                nbt.func_82580_o("Slot" + i);
                continue;
            }
            NBTTagCompound slot = new NBTTagCompound();
            ((ItemStack)this.mCraftMatrix.get(i)).func_77955_b(slot);
            nbt.func_74782_a("Slot" + i, (NBTBase)slot);
        }
    }

    private void readSlots(NBTTagCompound nbt) {
        int capacity = 9;
        if (nbt.func_150297_b("Capacity", 3)) {
            capacity = nbt.func_74762_e("Capacity");
        }
        this.ensureCraftMatrixCapacity(capacity);
        for (int i = 0; i < 9; ++i) {
            if (!nbt.func_150297_b("Slot" + i, 10)) {
                this.mCraftMatrix.set(i, (Object)ItemStack.field_190927_a);
                continue;
            }
            this.mCraftMatrix.set(i, (Object)new ItemStack(nbt.func_74775_l("Slot" + i)));
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readSlots(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeSlots(nbt);
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.writeSlots(nbt);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.readSlots(tag);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void ensureCraftMatrixCapacity(int capacity) {
        if (this.mCraftMatrix.size() != capacity) {
            this.mCraftMatrix = NonNullList.func_191197_a((int)capacity, (Object)ItemStack.field_190927_a);
        }
    }
}

