/*
 * Decompiled with CFR 0.152.
 */
package uk.co.proxying.tabmanager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.inject.Inject;
import io.github.nucleuspowered.nucleus.api.NucleusAPI;
import io.github.nucleuspowered.nucleus.api.service.NucleusNicknameService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.rojo8399.placeholderapi.PlaceholderService;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.slf4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameAboutToStartServerEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.service.ChangeServiceProviderEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.text.Text;
import uk.co.proxying.tabmanager.commands.MainCommand;
import uk.co.proxying.tabmanager.commands.ReloadCommand;
import uk.co.proxying.tabmanager.listeners.PlayerListener;
import uk.co.proxying.tabmanager.stats.Metrics;
import uk.co.proxying.tabmanager.tabObjects.BaseTab;
import uk.co.proxying.tabmanager.tabObjects.TabGroup;
import uk.co.proxying.tabmanager.tabObjects.TabPlayer;
import uk.co.proxying.tabmanager.utils.ScoreHandler;
import uk.co.proxying.tabmanager.utils.Utilities;

@Plugin(id="tabmanager", name="TabManager", version="2.1.3-S7.0-MC1.12.2", description="Customize your tab list in Sponge.", authors={"Proxying", "RandomByte"}, dependencies={@Dependency(id="placeholderapi"), @Dependency(id="nucleus")})
public class TabManager {
    @Inject
    private Logger logger;
    @Inject
    @ConfigDir(sharedRoot=false)
    private File configDir;
    @Inject
    @DefaultConfig(sharedRoot=false)
    private File defaultConfig;
    @Inject
    @DefaultConfig(sharedRoot=false)
    private ConfigurationLoader<CommentedConfigurationNode> configManager;
    private CommentedConfigurationNode configurationNode;
    @Inject
    private Game game;
    @Inject
    private Metrics metrics;
    private static TabManager instance;
    private PermissionService permissionService;
    private PlaceholderService placeholderService;
    private LinkedHashMap<String, TabGroup> tabGroups = new LinkedHashMap();
    private LinkedHashMap<UUID, TabPlayer> tabPlayers = new LinkedHashMap();
    private ConcurrentHashMap<UUID, BaseTab> playerGroups = new ConcurrentHashMap();
    private boolean changeVanilla = true;
    private boolean addToTeam = false;
    private int placeHolderUpdateIntervalSeconds = -1;
    private int groupUpdateIntervalSeconds = -1;
    private String tabHeader = "";
    private String tabFooter = "";
    private boolean useNicknames = false;
    private boolean attemptPlaceholders = false;
    private static final String PLACEHOLDER_UPDATE_TASK_NAME = "tabmanager-placeholder-updater";
    private static final String GROUP_UPDATE_TASK_NAME = "tabmanager-group-updater";

    @Listener
    public void preInit(GamePreInitializationEvent event) {
        this.logger.info("[TabManager 2.1.3-S7.0-MC1.12.2] is beginning setup.");
        this.logger.info("[TabManager 2.1.3-S7.0-MC1.12.2] uses bStats, not for any nefarious reasons, just because the author (Proxying) is nosey.");
        this.logger.info("[TabManager 2.1.3-S7.0-MC1.12.2] Feel free to disable this in the bStats config, but I'd appreciate it if you didn't.");
        instance = this;
        try {
            if (!this.defaultConfig.exists()) {
                this.defaultConfig.createNewFile();
                this.configurationNode = (CommentedConfigurationNode)this.configManager.load();
                this.configurationNode.getNode(new Object[]{"TabManager", "Edit Vanilla Tab List"}).setComment("This edits the Vanilla tab list (Will not effect the Pixelmon custom tab list, best to disable this when you have Pixelmon's enabled within the pixelmon.hocon.").setValue((Object)true);
                this.configurationNode.getNode(new Object[]{"TabManager", "Add Players to Teams"}).setComment("This will add players on the server to Teams within the scoreboard, this will override custom tab menus such as the Pixelmon GUI. Allowing for custom prefix/suffix within that. HOWEVER, this will also give the player a prefix and/or suffix while chatting in-game, so a plugin like Nucleus will have to also be used to handle chat if you want it to look different from your options here.").setValue((Object)false);
                this.configManager.save((ConfigurationNode)this.configurationNode);
            }
            this.configurationNode = (CommentedConfigurationNode)this.configManager.load();
            if (this.configurationNode.getNode(new Object[]{"TabManager", "update-interval"}).isVirtual()) {
                this.configurationNode.getNode(new Object[]{"TabManager", "update-interval"}).setComment("The interval in seconds in which the tab texts get updated. This is only needed when you are using PlaceholderAPI. Set to -1 to disable the updating.").setValue((Object)5);
                this.configManager.save((ConfigurationNode)this.configurationNode);
            }
            if (this.configurationNode.getNode(new Object[]{"TabManager", "Use Player Nicknames"}).isVirtual()) {
                this.configurationNode.getNode(new Object[]{"TabManager", "Use Player Nicknames"}).setComment("This will attempt to use a players display name/nickname rather than their actual Minecraft name.").setValue((Object)false);
                this.configManager.save((ConfigurationNode)this.configurationNode);
            }
            if (this.configurationNode.getNode(new Object[]{"TabManager", "group-update-interval"}).isVirtual()) {
                this.configurationNode.getNode(new Object[]{"TabManager", "group-update-interval"}).setComment("The interval in seconds in which players groups get re-checked for updates (such as purchasingdonation ranks, becoming staff etc. [This is performance heavy, so do NOT set it too low. Default is 60, recommended is no less than that]. Set to -1 to disable the updating.").setValue((Object)60);
                this.configManager.save((ConfigurationNode)this.configurationNode);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.info("[TabManager 2.1.3-S7.0-MC1.12.2] has finished setup.");
    }

    @Listener
    public void onChangeServiceProvider(ChangeServiceProviderEvent event) {
        if (event.getService().equals(PermissionService.class)) {
            this.permissionService = (PermissionService)event.getNewProviderRegistration().getProvider();
        }
        if (Sponge.getPluginManager().getPlugin("placeholderapi").isPresent() && event.getService().equals(PlaceholderService.class)) {
            this.placeholderService = (PlaceholderService)event.getNewProviderRegistration().getProvider();
        }
    }

    @Listener
    public void aboutToStart(GameAboutToStartServerEvent event) {
        EventManager em = this.game.getEventManager();
        Sponge.getCommandManager().register((Object)this, (CommandCallable)CommandSpec.builder().permission("tabmanager.use").executor((CommandExecutor)new MainCommand()).description((Text)Text.of((String)"The main Tab Manager Command")).child((CommandCallable)CommandSpec.builder().executor((CommandExecutor)new ReloadCommand()).description((Text)Text.of((String)"Used to refresh the plugin after edits have been made to the config(s).")).build(), new String[]{"reload"}).build(), new String[]{"tab", "tm", "tabs"});
        em.registerListeners((Object)this, (Object)new PlayerListener());
    }

    @Listener
    public void onServerStart(GameStartedServerEvent event) {
        this.refreshCache();
        Utilities.scheduleSyncTask(() -> ScoreHandler.getInstance().setup(), 20);
        this.startUpdateTask();
    }

    @Listener
    public void onServerReload(GameReloadEvent event) {
        this.refreshCache();
        this.refreshCurrentPlayers();
        this.startUpdateTask();
    }

    public void refreshCurrentPlayers() {
        this.playerGroups.clear();
        ScoreHandler.getInstance().clearTeams();
        for (Player player : Sponge.getServer().getOnlinePlayers()) {
            Utilities.checkAndUpdateName(player, true);
        }
    }

    public void refreshCache() {
        Object groupName;
        JsonObject defaultGroup;
        Object display;
        JsonObject singularGroup;
        JsonObject groupsObject;
        JsonObject jsonObject;
        JsonParser parser;
        FileWriter file;
        String prettyOutput;
        JsonObject base;
        Gson gson;
        if (this.permissionService == null) {
            this.logger.warn("Permission service not present, things will not work...");
        }
        this.changeVanilla = this.getRootNode().getNode(new Object[]{"TabManager", "Edit Vanilla Tab List"}).getBoolean();
        this.addToTeam = this.getRootNode().getNode(new Object[]{"TabManager", "Add Players to Teams"}).getBoolean();
        this.placeHolderUpdateIntervalSeconds = this.getRootNode().getNode(new Object[]{"TabManager", "update-interval"}).getInt();
        this.groupUpdateIntervalSeconds = this.getRootNode().getNode(new Object[]{"TabManager", "group-update-interval"}).getInt();
        this.useNicknames = this.getRootNode().getNode(new Object[]{"TabManager", "Use Player Nicknames"}).getBoolean();
        this.tabGroups.clear();
        this.tabPlayers.clear();
        this.tabHeader = "";
        this.tabFooter = "";
        if (!Files.exists(Paths.get(this.configDir + File.separator + "vanilla.json", new String[0]), new LinkOption[0])) {
            try {
                Files.createFile(Paths.get(this.configDir + File.separator + "vanilla.json", new String[0]), new FileAttribute[0]);
                gson = new GsonBuilder().setPrettyPrinting().create();
                base = new JsonObject();
                JsonObject examples = new JsonObject();
                JsonObject header = new JsonObject();
                examples.add("header", (JsonElement)header);
                header.addProperty("type", "Header");
                header.addProperty("display", "This is a header");
                JsonObject footer = new JsonObject();
                examples.add("footer", (JsonElement)footer);
                footer.addProperty("type", "Footer");
                footer.addProperty("display", "This is a footer");
                base.add("options", (JsonElement)examples);
                prettyOutput = gson.toJson((JsonElement)base);
                try {
                    file = new FileWriter(new File(this.configDir, "vanilla.json"));
                    Throwable throwable = null;
                    try {
                        file.write(prettyOutput);
                        file.flush();
                        file.close();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (file != null) {
                            if (throwable != null) {
                                try {
                                    file.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                file.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                parser = new JsonParser();
                jsonObject = (JsonObject)parser.parse((Reader)new FileReader(new File(this.configDir, "vanilla.json")));
                groupsObject = jsonObject.getAsJsonObject("options");
                for (Map.Entry entry : groupsObject.entrySet()) {
                    singularGroup = (JsonObject)entry.getValue();
                    String type = singularGroup.get("type").getAsString();
                    if (type == null || type.isEmpty()) continue;
                    display = singularGroup.get("display").getAsString();
                    if (type.equalsIgnoreCase("header")) {
                        this.tabHeader = display;
                    } else if (type.equalsIgnoreCase("footer")) {
                        this.tabFooter = display;
                    }
                    this.logger.info(type.toLowerCase() + " found. Inserting into cache. " + (String)display);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.logger.info("Checking for groups file and populating groups. Best of luck kids.");
        if (!Files.exists(Paths.get(this.configDir + File.separator + "groups.json", new String[0]), new LinkOption[0])) {
            try {
                Files.createFile(Paths.get(this.configDir + File.separator + "groups.json", new String[0]), new FileAttribute[0]);
                gson = new GsonBuilder().setPrettyPrinting().create();
                base = new JsonObject();
                JsonObject groups = new JsonObject();
                defaultGroup = new JsonObject();
                groups.add("HIGHEST_GROUP_(OWNER)", (JsonElement)defaultGroup);
                defaultGroup.addProperty("name", "owner");
                defaultGroup.addProperty("prefix", "[OWNER]");
                defaultGroup.addProperty("suffix", "[OWNER]");
                for (int i = 0; i < 3; ++i) {
                    singularGroup = new JsonObject();
                    groups.add("LOWER_GROUP_(" + i + ")", (JsonElement)singularGroup);
                    singularGroup.addProperty("name", "group" + i);
                    singularGroup.addProperty("prefix", "[PREFIX]");
                    singularGroup.addProperty("suffix", "[SUFFIX]");
                }
                base.add("groupList", (JsonElement)groups);
                JsonObject lowestGroup = new JsonObject();
                groups.add("LOWEST_GROUP(DEFAULT)", (JsonElement)lowestGroup);
                lowestGroup.addProperty("name", "default");
                lowestGroup.addProperty("prefix", "[DEFAULT]");
                lowestGroup.addProperty("suffix", "[DEFAULT]");
                prettyOutput = gson.toJson((JsonElement)base);
                try {
                    file = new FileWriter(new File(this.configDir, "groups.json"));
                    display = null;
                    try {
                        file.write(prettyOutput);
                        file.flush();
                        file.close();
                    }
                    catch (Throwable throwable) {
                        display = throwable;
                        throw throwable;
                    }
                    finally {
                        if (file != null) {
                            if (display != null) {
                                try {
                                    file.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)display).addSuppressed(throwable);
                                }
                            } else {
                                file.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                parser = new JsonParser();
                jsonObject = (JsonObject)parser.parse((Reader)new FileReader(new File(this.configDir, "groups.json")));
                groupsObject = jsonObject.getAsJsonObject("groupList");
                for (Map.Entry entry : groupsObject.entrySet()) {
                    singularGroup = (JsonObject)entry.getValue();
                    groupName = singularGroup.get("name").getAsString();
                    if (groupName == null || ((String)groupName).isEmpty()) continue;
                    String groupPrefix = singularGroup.get("prefix").getAsString();
                    String groupSuffix = singularGroup.get("suffix").getAsString();
                    TabGroup tabGroup = new TabGroup((String)groupName, groupPrefix, groupSuffix);
                    this.tabGroups.put(((String)groupName).toLowerCase(), tabGroup);
                    this.logger.info("Group " + ((String)groupName).toLowerCase() + " found. Inserting into cache.");
                }
                if (this.tabGroups.isEmpty()) {
                    this.logger.warn("No groups found within groups.json!");
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.logger.info("Checking for players file and populating players. Best of luck kids.");
        if (!Files.exists(Paths.get(this.configDir + File.separator + "players.json", new String[0]), new LinkOption[0])) {
            try {
                Files.createFile(Paths.get(this.configDir + File.separator + "players.json", new String[0]), new FileAttribute[0]);
                gson = new GsonBuilder().setPrettyPrinting().create();
                base = new JsonObject();
                JsonObject players = new JsonObject();
                defaultGroup = new JsonObject();
                players.add("Notch", (JsonElement)defaultGroup);
                defaultGroup.addProperty("uuid", "069a79f4-44e9-4726-a5be-fca90e38aaf5");
                defaultGroup.addProperty("prefix", "[NOTCH]");
                defaultGroup.addProperty("suffix", "[NOTCH]");
                base.add("playerList", (JsonElement)players);
                String prettyOutput2 = gson.toJson((JsonElement)base);
                try {
                    FileWriter file2 = new FileWriter(new File(this.configDir, "players.json"));
                    groupName = null;
                    try {
                        file2.write(prettyOutput2);
                        file2.flush();
                        file2.close();
                    }
                    catch (Throwable groupPrefix) {
                        groupName = groupPrefix;
                        throw groupPrefix;
                    }
                    finally {
                        if (file2 != null) {
                            if (groupName != null) {
                                try {
                                    file2.close();
                                }
                                catch (Throwable groupPrefix) {
                                    ((Throwable)groupName).addSuppressed(groupPrefix);
                                }
                            } else {
                                file2.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                parser = new JsonParser();
                jsonObject = (JsonObject)parser.parse((Reader)new FileReader(new File(this.configDir, "players.json")));
                JsonObject playersObject = jsonObject.getAsJsonObject("playerList");
                HashMap<UUID, TabPlayer> playerMap = new HashMap<UUID, TabPlayer>();
                for (Map.Entry entry : playersObject.entrySet()) {
                    UUID uuid;
                    JsonObject singularGroup2 = (JsonObject)entry.getValue();
                    String playerUUID = singularGroup2.get("uuid").getAsString();
                    if (playerUUID == null || playerUUID.isEmpty()) continue;
                    try {
                        uuid = UUID.fromString(playerUUID);
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.warn("Invalid UUID of " + playerUUID + " found.");
                        continue;
                    }
                    String playerPrefix = singularGroup2.get("prefix").getAsString();
                    String playerSuffix = singularGroup2.get("suffix").getAsString();
                    TabPlayer tabPlayer = new TabPlayer(uuid, playerPrefix, playerSuffix);
                    playerMap.put(uuid, tabPlayer);
                    this.logger.info("Player " + playerUUID + " found. Inserting into cache.");
                }
                if (!playerMap.isEmpty()) {
                    this.tabPlayers.putAll(playerMap);
                } else {
                    this.logger.warn("No groups found within groups.json!");
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (this.tabFooter.contains("%") && this.tabFooter.indexOf("%") != this.tabFooter.lastIndexOf("%") || this.tabHeader.contains("%") && this.tabHeader.indexOf("%") != this.tabHeader.lastIndexOf("%")) {
            this.attemptPlaceholders = true;
            this.logger.info("Attempting to place placeholders is TRUE");
        }
    }

    public ConfigurationNode getRootNode() {
        try {
            return this.configManager.load();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void startUpdateTask() {
        for (Task task : Sponge.getScheduler().getTasksByName(PLACEHOLDER_UPDATE_TASK_NAME)) {
            task.cancel();
        }
        for (Task task : Sponge.getScheduler().getTasksByName(GROUP_UPDATE_TASK_NAME)) {
            task.cancel();
        }
        if (this.placeHolderUpdateIntervalSeconds > 1) {
            Task.builder().name(PLACEHOLDER_UPDATE_TASK_NAME).interval((long)this.placeHolderUpdateIntervalSeconds, TimeUnit.SECONDS).execute(() -> {
                for (Player player : Sponge.getServer().getOnlinePlayers()) {
                    Utilities.checkAndUpdateName(player, false);
                }
            }).submit((Object)this);
        }
        if (this.groupUpdateIntervalSeconds > 1) {
            Task.builder().name(GROUP_UPDATE_TASK_NAME).interval((long)this.groupUpdateIntervalSeconds, TimeUnit.SECONDS).async().execute(() -> {
                for (Player player : Sponge.getServer().getOnlinePlayers()) {
                    Utilities.checkAndUpdateGroup(player);
                }
            }).submit((Object)this);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean isUseNicknames(Player player) {
        return this.useNicknames && NucleusAPI.getNicknameService().isPresent() && ((NucleusNicknameService)NucleusAPI.getNicknameService().get()).getNickname((User)player).isPresent();
    }

    public static TabManager getInstance() {
        return instance;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public PlaceholderService getPlaceholderService() {
        return this.placeholderService;
    }

    public LinkedHashMap<String, TabGroup> getTabGroups() {
        return this.tabGroups;
    }

    public LinkedHashMap<UUID, TabPlayer> getTabPlayers() {
        return this.tabPlayers;
    }

    public ConcurrentHashMap<UUID, BaseTab> getPlayerGroups() {
        return this.playerGroups;
    }

    public boolean isChangeVanilla() {
        return this.changeVanilla;
    }

    public boolean isAddToTeam() {
        return this.addToTeam;
    }

    public int getPlaceHolderUpdateIntervalSeconds() {
        return this.placeHolderUpdateIntervalSeconds;
    }

    public int getGroupUpdateIntervalSeconds() {
        return this.groupUpdateIntervalSeconds;
    }

    public String getTabHeader() {
        return this.tabHeader;
    }

    public String getTabFooter() {
        return this.tabFooter;
    }

    public boolean isAttemptPlaceholders() {
        return this.attemptPlaceholders;
    }
}

