/*
 * Decompiled with CFR 0.152.
 */
package uk.co.proxying.tabmanager.utils;

import io.github.nucleuspowered.nucleus.api.NucleusAPI;
import io.github.nucleuspowered.nucleus.api.service.NucleusNicknameService;
import java.util.Map;
import java.util.regex.Pattern;
import me.rojo8399.placeholderapi.PlaceholderService;
import me.rojo8399.placeholderapi.impl.utils.TextUtils;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.tab.TabListEntry;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import uk.co.proxying.tabmanager.TabManager;
import uk.co.proxying.tabmanager.tabObjects.BaseTab;
import uk.co.proxying.tabmanager.tabObjects.TabGroup;
import uk.co.proxying.tabmanager.tabObjects.TabPlayer;
import uk.co.proxying.tabmanager.utils.PermsHelper;
import uk.co.proxying.tabmanager.utils.ScoreHandler;

public class Utilities {
    public static void scheduleAsyncTask(Runnable runnable, int delayTicks) {
        Sponge.getScheduler().createTaskBuilder().execute(runnable).delayTicks((long)delayTicks).async().submit((Object)TabManager.getInstance());
    }

    public static void scheduleSyncTask(Runnable runnable, int delayTicks) {
        Sponge.getScheduler().createTaskBuilder().execute(runnable).delayTicks((long)delayTicks).submit((Object)TabManager.getInstance());
    }

    public static void scheduleAsyncRepeatingTask(Runnable runnable, int intervalTicks) {
        Sponge.getScheduler().createTaskBuilder().execute(runnable).intervalTicks((long)intervalTicks).async().submit((Object)TabManager.getInstance());
    }

    public static void scheduleSyncRepeatingTask(Runnable runnable, int intervalTicks) {
        Sponge.getScheduler().createTaskBuilder().execute(runnable).intervalTicks((long)intervalTicks).submit((Object)TabManager.getInstance());
    }

    private static void updateForcedPlayerName(Player player) {
        TabPlayer tabPlayer = TabManager.getInstance().getTabPlayers().get(player.getUniqueId());
        if (tabPlayer != null) {
            if (TabManager.getInstance().isAddToTeam()) {
                ScoreHandler.getInstance().addPlayerSoloData(player, tabPlayer);
            }
            TabManager.getInstance().getPlayerGroups().put(player.getUniqueId(), tabPlayer);
            if (!TabManager.getInstance().isChangeVanilla()) {
                return;
            }
            StringBuilder toUpdate = new StringBuilder();
            toUpdate.append(tabPlayer.getPrefix()).append(TabManager.getInstance().isUseNicknames(player) ? Utilities.checkPlayerNickname(player).toPlain() : player.getName()).append(tabPlayer.getSuffix());
            Text displayThis = Utilities.tryFillPlaceholders(player, toUpdate.toString());
            if (player.getTabList().getEntry(player.getUniqueId()).isPresent()) {
                ((TabListEntry)player.getTabList().getEntry(player.getUniqueId()).get()).setDisplayName(displayThis);
            }
        }
    }

    public static void updateGroupPlayerName(Player player, TabGroup playerGroup) {
        if (playerGroup != null) {
            if (TabManager.getInstance().isAddToTeam()) {
                ScoreHandler.getInstance().addPlayerGroupData(player, playerGroup);
            }
            if (!TabManager.getInstance().isChangeVanilla()) {
                return;
            }
            StringBuilder toUpdate = new StringBuilder();
            toUpdate.append(playerGroup.getPrefix()).append(TabManager.getInstance().isUseNicknames(player) ? Utilities.checkPlayerNickname(player).toPlain() : player.getName()).append(playerGroup.getSuffix());
            Text displayThis = Utilities.tryFillPlaceholders(player, toUpdate.toString());
            if (player.getTabList().getEntry(player.getUniqueId()).isPresent()) {
                ((TabListEntry)player.getTabList().getEntry(player.getUniqueId()).get()).setDisplayName(displayThis);
            }
        }
    }

    public static void checkAndUpdateName(Player player, boolean forceGroupRecheck) {
        BaseTab baseTab;
        Utilities.updateOtherUsersForPlayer(player);
        if (!TabManager.getInstance().getTabHeader().equalsIgnoreCase("")) {
            player.getTabList().setHeader(TabManager.getInstance().isAttemptPlaceholders() ? Utilities.attemptFillPlaceHolders(player, TabManager.getInstance().getTabHeader()) : Utilities.deserializeText(TabManager.getInstance().getTabHeader()));
        }
        if (!TabManager.getInstance().getTabFooter().equalsIgnoreCase("")) {
            player.getTabList().setFooter(TabManager.getInstance().isAttemptPlaceholders() ? Utilities.attemptFillPlaceHolders(player, TabManager.getInstance().getTabFooter()) : Utilities.deserializeText(TabManager.getInstance().getTabFooter()));
        }
        if (TabManager.getInstance().getTabPlayers().containsKey(player.getUniqueId())) {
            Utilities.updateForcedPlayerName(player);
            return;
        }
        if (forceGroupRecheck) {
            Utilities.checkAndUpdateGroup(player);
        } else if (TabManager.getInstance().getPlayerGroups().get(player.getUniqueId()) != null && (baseTab = TabManager.getInstance().getPlayerGroups().get(player.getUniqueId())) instanceof TabGroup) {
            Utilities.updateGroupPlayerName(player, (TabGroup)baseTab);
        }
    }

    public static void checkAndUpdateGroup(Player player) {
        TabGroup tabGroup;
        BaseTab oldTab = TabManager.getInstance().getPlayerGroups().get(player.getUniqueId());
        TabGroup oldGroup = null;
        if (oldTab != null && oldTab instanceof TabGroup) {
            oldGroup = (TabGroup)oldTab;
        }
        if ((tabGroup = PermsHelper.findCorrectGroup((User)player, oldGroup)) != null) {
            TabManager.getInstance().getPlayerGroups().put(player.getUniqueId(), tabGroup);
        }
    }

    private static void updateOtherUsersForPlayer(Player player) {
        for (Player player1 : Sponge.getServer().getOnlinePlayers()) {
            Text displayThis;
            StringBuilder toUpdate;
            BaseTab tab;
            if (player1.get(Keys.VANISH).orElse(false).booleanValue()) {
                if (player.equals(player1) || player.hasPermission("nucleus.vanish.see") || !player.getTabList().getEntry(player1.getUniqueId()).isPresent()) continue;
                player.getTabList().removeEntry(player1.getUniqueId());
                continue;
            }
            if (player.getTabList().getEntry(player1.getUniqueId()).isPresent()) {
                tab = TabManager.getInstance().getTabPlayers().get(player1.getUniqueId());
                if (tab == null && (tab = TabManager.getInstance().getPlayerGroups().get(player1.getUniqueId())) == null) continue;
                toUpdate = new StringBuilder();
                toUpdate.append(tab.getPrefix()).append(TabManager.getInstance().isUseNicknames(player1) ? Utilities.checkPlayerNickname(player1).toPlain() : player1.getName()).append(tab.getSuffix());
                displayThis = Utilities.tryFillPlaceholders(player, toUpdate.toString());
                ((TabListEntry)player.getTabList().getEntry(player1.getUniqueId()).get()).setDisplayName(displayThis);
                continue;
            }
            tab = TabManager.getInstance().getTabPlayers().get(player1.getUniqueId());
            if (tab == null && (tab = TabManager.getInstance().getPlayerGroups().get(player1.getUniqueId())) == null) continue;
            toUpdate = new StringBuilder();
            toUpdate.append(tab.getPrefix()).append(TabManager.getInstance().isUseNicknames(player1) ? Utilities.checkPlayerNickname(player1).toPlain() : player1.getName()).append(tab.getSuffix());
            displayThis = Utilities.tryFillPlaceholders(player, toUpdate.toString());
            player.getTabList().addEntry(TabListEntry.builder().displayName(displayThis).profile(player1.getProfile()).gameMode((GameMode)player1.gameMode().get()).latency(player1.getConnection().getLatency()).list(player.getTabList()).build());
        }
    }

    private static Text tryFillPlaceholders(Player targetPlayer, String string) {
        PlaceholderService placeholderService = TabManager.getInstance().getPlaceholderService();
        if (placeholderService != null) {
            return placeholderService.replacePlaceholders(string, (Object)targetPlayer, null);
        }
        return Utilities.deserializeText(string);
    }

    private static Text attemptFillPlaceHolders(Player target, String string) {
        PlaceholderService placeholderService = TabManager.getInstance().getPlaceholderService();
        if (placeholderService != null) {
            Map retreivedPlaceholders = placeholderService.fillPlaceholders(TextUtils.parse((String)string, (Pattern)placeholderService.getDefaultPattern()), (Object)target, null);
            for (Map.Entry entry : retreivedPlaceholders.entrySet()) {
                if (entry.getValue() instanceof Text) {
                    if (string.contains((CharSequence)entry.getKey())) {
                        string = string.replaceAll("%" + (String)entry.getKey() + "%", ((Text)entry.getValue()).toPlain());
                        continue;
                    }
                    TabManager.getInstance().getLogger().info("Cannot find key " + (String)entry.getKey() + " in string.");
                    continue;
                }
                if (string.contains((CharSequence)entry.getKey())) {
                    string = string.replaceAll("%" + (String)entry.getKey() + "%", String.valueOf(entry.getValue()));
                    continue;
                }
                TabManager.getInstance().getLogger().info("Cannot find key " + (String)entry.getKey() + " in string.");
            }
            return Utilities.deserializeText(string);
        }
        TabManager.getInstance().getLogger().info("placeholder service null?");
        return Utilities.deserializeText(string);
    }

    private static Text deserializeText(String string) {
        return TextSerializers.FORMATTING_CODE.deserialize(string);
    }

    private static Text checkPlayerNickname(Player player) {
        return (Text)((NucleusNicknameService)NucleusAPI.getNicknameService().get()).getNickname((User)player).get();
    }
}

