/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.features;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.FeatureBase;
import com.mcmoddev.orespawn.api.IFeature;
import com.mcmoddev.orespawn.api.os3.ISpawnEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class VeinGenerator
extends FeatureBase
implements IFeature {
    private static final EnumFacing[][][] congruentSquares = new EnumFacing[][][]{{{EnumFacing.SOUTH, null}, {EnumFacing.WEST, null}, {EnumFacing.NORTH, null}, {EnumFacing.EAST, null}, {EnumFacing.SOUTH, EnumFacing.WEST}, {EnumFacing.NORTH, EnumFacing.WEST}, {EnumFacing.SOUTH, EnumFacing.EAST}, {EnumFacing.SOUTH, EnumFacing.EAST}}, {{EnumFacing.SOUTH, null}, {EnumFacing.WEST, null}, {EnumFacing.NORTH, null}, {EnumFacing.EAST, null}, {EnumFacing.SOUTH, EnumFacing.WEST}, {EnumFacing.NORTH, EnumFacing.WEST}, {EnumFacing.SOUTH, EnumFacing.EAST}, {EnumFacing.SOUTH, EnumFacing.EAST}}, {{EnumFacing.UP, null}, {EnumFacing.WEST, null}, {EnumFacing.DOWN, null}, {EnumFacing.EAST, null}, {EnumFacing.UP, EnumFacing.WEST}, {EnumFacing.DOWN, EnumFacing.WEST}, {EnumFacing.DOWN, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.EAST}}, {{EnumFacing.UP, null}, {EnumFacing.EAST, null}, {EnumFacing.DOWN, null}, {EnumFacing.WEST, null}, {EnumFacing.UP, EnumFacing.EAST}, {EnumFacing.DOWN, EnumFacing.EAST}, {EnumFacing.DOWN, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.WEST}}, {{EnumFacing.UP, null}, {EnumFacing.SOUTH, null}, {EnumFacing.DOWN, null}, {EnumFacing.NORTH, null}, {EnumFacing.UP, EnumFacing.SOUTH}, {EnumFacing.DOWN, EnumFacing.SOUTH}, {EnumFacing.DOWN, EnumFacing.NORTH}, {EnumFacing.UP, EnumFacing.NORTH}}, {{EnumFacing.UP, null}, {EnumFacing.NORTH, null}, {EnumFacing.DOWN, null}, {EnumFacing.SOUTH, null}, {EnumFacing.UP, EnumFacing.NORTH}, {EnumFacing.DOWN, EnumFacing.NORTH}, {EnumFacing.DOWN, EnumFacing.SOUTH}, {EnumFacing.UP, EnumFacing.SOUTH}}};

    private VeinGenerator(Random rand) {
        super(rand);
    }

    public VeinGenerator() {
        this(new Random());
    }

    @Override
    public void generate(World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider, ISpawnEntry spawnData, ChunkPos _pos) {
        ChunkPos pos = _pos;
        JsonObject params = spawnData.getFeature().getFeatureParameters();
        int chunkX = pos.field_77276_a;
        int chunkZ = pos.field_77275_b;
        this.runCache(chunkX, chunkZ, world, spawnData);
        VeinGenerator.mergeDefaults(params, this.getDefaultParameters());
        int blockX = chunkX * 16 + 8;
        int blockZ = chunkZ * 16 + 8;
        int minY = params.get("minHeight").getAsInt();
        int maxY = params.get("maxHeight").getAsInt();
        int vari = params.get("variation").getAsInt();
        int freq = params.get("frequency").getAsInt();
        int length = params.get("length").getAsInt();
        EnumFacing startingFace = this.getFaceFromString(params.get("startFacing").getAsString());
        int nodeSize = params.get("size").getAsInt();
        int triesMin = params.get("minAttempts").getAsInt();
        int triesMax = params.get("maxAttempts").getAsInt();
        for (int tries = triesMax == triesMin ? triesMax : this.random.nextInt(triesMax - triesMin) + triesMin; tries > 0; --tries) {
            if (this.random.nextInt(100) > freq) continue;
            int x = blockX + this.random.nextInt(16);
            int y = this.random.nextInt(maxY - minY) + minY;
            int z = blockZ + this.random.nextInt(16);
            int r = vari > 0 ? this.random.nextInt(2 * vari) - vari : 0;
            this.spawnVein(length + r, nodeSize, startingFace, new BlockPos(x, y, z), spawnData, world);
        }
    }

    private EnumFacing getFaceFromString(String direction) {
        String work;
        switch (work = direction.toLowerCase()) {
            case "north": {
                return EnumFacing.NORTH;
            }
            case "south": {
                return EnumFacing.SOUTH;
            }
            case "east": {
                return EnumFacing.EAST;
            }
            case "west": {
                return EnumFacing.WEST;
            }
            case "down": {
                return EnumFacing.DOWN;
            }
            case "up": {
                return EnumFacing.UP;
            }
            case "random": {
                return EnumFacing.field_82609_l[this.random.nextInt(EnumFacing.field_82609_l.length)];
            }
            case "vertical": {
                return this.random.nextBoolean() ? EnumFacing.UP : EnumFacing.DOWN;
            }
            case "horizontal": {
                return EnumFacing.field_176754_o[this.random.nextInt(EnumFacing.field_176754_o.length)];
            }
        }
        OreSpawn.LOGGER.error("Invalid value %s found in parameters for vein spawn, returning \"north\"", (Object)direction);
        return EnumFacing.NORTH;
    }

    private void spawnVein(int veinLength, int nodeSize, EnumFacing startingFace, BlockPos blockPos, ISpawnEntry spawnData, World world) {
        EnumFacing face = startingFace;
        EnumSquare square = EnumSquare.values()[this.random.nextInt(EnumSquare.values().length)];
        BlockPos workingPos = new BlockPos((Vec3i)blockPos);
        if (!spawnData.getMatcher().test(world.func_180495_p(blockPos))) {
            return;
        }
        LinkedList points = Lists.newLinkedList();
        while (points.size() < veinLength) {
            points.add(workingPos);
            List<EnumFacing> nextFaces = this.getNextFaceSet(square, face);
            if (!nextFaces.isEmpty()) {
                BlockPos temp = workingPos;
                for (EnumFacing f : nextFaces) {
                    temp = temp.func_177967_a(f, 1);
                }
                nextFaces.clear();
                points.add(temp);
                workingPos = temp;
            }
            face = this.getNextStartingFace(square, face);
            square = this.getNextSquare();
        }
        this.spawnOre(world, spawnData, blockPos, nodeSize);
        for (BlockPos pos : points) {
            this.spawnOre(world, spawnData, pos, nodeSize);
        }
    }

    private EnumSquare getNextSquare() {
        float[] weights = new float[]{0.12f, 0.12f, 0.12f, 0.12f, 0.0475f, 0.0475f, 0.0475f, 0.0475f, 0.33f};
        ArrayList<SquareWeight> items = new ArrayList<SquareWeight>();
        for (EnumSquare sq : EnumSquare.values()) {
            items.add(new SquareWeight(sq, (int)(weights[sq.getIndex()] * 10000.0f)));
        }
        return ((SquareWeight)WeightedRandom.func_76271_a((Random)this.random, items)).item;
    }

    private EnumFacing getNextStartingFace(EnumSquare square, EnumFacing face) {
        if (this.random.nextBoolean() || square == EnumSquare.FACE) {
            return face;
        }
        EnumFacing[] possibles = (EnumFacing[])Arrays.asList(congruentSquares[face.func_176745_a()][square.getIndex()]).stream().filter(it -> it != null).toArray(EnumFacing[]::new);
        if (possibles.length > 1) {
            return possibles[this.random.nextInt(possibles.length)];
        }
        return possibles[0];
    }

    private List<EnumFacing> getNextFaceSet(EnumSquare square, EnumFacing face) {
        ArrayList<EnumFacing> rv = new ArrayList<EnumFacing>();
        rv.add(face);
        block0 : switch (square) {
            case BOTTOM_EDGE: {
                switch (face) {
                    case EAST: 
                    case WEST: 
                    case NORTH: 
                    case SOUTH: {
                        rv.add(EnumFacing.DOWN);
                        break block0;
                    }
                    case UP: 
                    case DOWN: {
                        rv.add(EnumFacing.NORTH);
                        break block0;
                    }
                }
                break;
            }
            case TOP_EDGE: {
                switch (face) {
                    case EAST: 
                    case WEST: 
                    case NORTH: 
                    case SOUTH: {
                        rv.add(EnumFacing.UP);
                        break block0;
                    }
                    case UP: 
                    case DOWN: {
                        rv.add(EnumFacing.SOUTH);
                        break block0;
                    }
                }
                break;
            }
            case LEFT_EDGE: {
                switch (face) {
                    case EAST: 
                    case WEST: 
                    case NORTH: 
                    case SOUTH: {
                        rv.add(face.func_176735_f());
                        break block0;
                    }
                    case UP: 
                    case DOWN: {
                        rv.add(EnumFacing.EAST);
                        break block0;
                    }
                }
                break;
            }
            case RIGHT_EDGE: {
                switch (face) {
                    case EAST: 
                    case WEST: 
                    case NORTH: 
                    case SOUTH: {
                        rv.add(face.func_176746_e());
                        break block0;
                    }
                    case UP: 
                    case DOWN: {
                        rv.add(EnumFacing.WEST);
                        break block0;
                    }
                }
                break;
            }
            case FACE: {
                break;
            }
            case LEFT_TOP: {
                switch (face) {
                    case EAST: 
                    case WEST: 
                    case NORTH: 
                    case SOUTH: {
                        rv.add(face.func_176735_f());
                        rv.add(EnumFacing.UP);
                        break block0;
                    }
                    case UP: 
                    case DOWN: {
                        rv.add(EnumFacing.EAST);
                        rv.add(EnumFacing.SOUTH);
                        break block0;
                    }
                }
                break;
            }
            case LEFT_BOTTOM: {
                switch (face) {
                    case EAST: 
                    case WEST: 
                    case NORTH: 
                    case SOUTH: {
                        rv.add(face.func_176735_f());
                        rv.add(EnumFacing.DOWN);
                        break block0;
                    }
                    case UP: 
                    case DOWN: {
                        rv.add(EnumFacing.EAST);
                        rv.add(EnumFacing.NORTH);
                        break block0;
                    }
                }
                break;
            }
            case RIGHT_TOP: {
                switch (face) {
                    case EAST: 
                    case WEST: 
                    case NORTH: 
                    case SOUTH: {
                        rv.add(face.func_176746_e());
                        rv.add(EnumFacing.UP);
                        break block0;
                    }
                    case UP: 
                    case DOWN: {
                        rv.add(EnumFacing.EAST);
                        rv.add(EnumFacing.SOUTH);
                        break block0;
                    }
                }
                break;
            }
            case RIGHT_BOTTOM: {
                switch (face) {
                    case EAST: 
                    case WEST: 
                    case NORTH: 
                    case SOUTH: {
                        rv.add(face.func_176746_e());
                        rv.add(EnumFacing.DOWN);
                        break block0;
                    }
                    case UP: 
                    case DOWN: {
                        rv.add(EnumFacing.EAST);
                        rv.add(EnumFacing.NORTH);
                        break block0;
                    }
                }
                break;
            }
        }
        return rv;
    }

    private void spawnOre(World world, ISpawnEntry spawnData, BlockPos pos, int quantity) {
        int count = quantity;
        int lutType = quantity < 8 ? offsetIndexRef_small.length : offsetIndexRef.length;
        int[] lut = quantity < 8 ? offsetIndexRef_small : offsetIndexRef;
        Vec3i[] offs = new Vec3i[lutType];
        System.arraycopy(quantity < 8 ? offsets_small : offsets, 0, offs, 0, lutType);
        if (quantity < 27) {
            int[] scrambledLUT = new int[lutType];
            System.arraycopy(lut, 0, scrambledLUT, 0, scrambledLUT.length);
            this.scramble(scrambledLUT, this.random);
            while (count > 0) {
                IBlockState oreBlock = spawnData.getBlocks().getRandomBlock(this.random);
                if (oreBlock.func_177230_c().equals(Blocks.field_150350_a)) {
                    return;
                }
                BlockPos target = pos.func_177971_a(offs[scrambledLUT[--count]]);
                this.spawn(oreBlock, world, target, world.field_73011_w.getDimension(), true, spawnData);
            }
            return;
        }
        this.doSpawnFill(this.random.nextBoolean(), count, world, spawnData, pos);
    }

    private void doSpawnFill(boolean nextBoolean, int quantity, World world, ISpawnEntry spawnData, BlockPos pos) {
        int count = quantity;
        double radius = Math.pow(quantity, 0.3333333333333333) * 0.238732414637843 + 2.0;
        int rSqr = (int)(radius * radius);
        if (nextBoolean) {
            this.spawnMungeNE(world, pos, rSqr, radius, spawnData, count);
        } else {
            this.spawnMungeSW(world, pos, rSqr, radius, spawnData, count);
        }
    }

    @Override
    public JsonObject getDefaultParameters() {
        JsonObject defParams = new JsonObject();
        defParams.addProperty("minHeight", (Number)0);
        defParams.addProperty("maxHeight", (Number)256);
        defParams.addProperty("variation", (Number)16);
        defParams.addProperty("frequency", (Number)50);
        defParams.addProperty("maxAttempts", (Number)8);
        defParams.addProperty("minAttempts", (Number)4);
        defParams.addProperty("length", (Number)16);
        defParams.addProperty("startFacing", "north");
        defParams.addProperty("size", (Number)3);
        return defParams;
    }

    @Override
    public void setRandom(Random rand) {
        this.random = rand;
    }

    private class SquareWeight
    extends WeightedRandom.Item {
        private EnumSquare item;

        public SquareWeight(EnumSquare item, int weight) {
            super(weight);
            this.item = item;
        }
    }

    private static enum EnumSquare {
        TOP_EDGE(0),
        LEFT_EDGE(1),
        BOTTOM_EDGE(2),
        RIGHT_EDGE(3),
        LEFT_TOP(4),
        LEFT_BOTTOM(5),
        RIGHT_TOP(6),
        RIGHT_BOTTOM(7),
        FACE(8);

        private int index;

        private EnumSquare(int index) {
            this.index = index;
        }

        public final int getIndex() {
            return this.index;
        }
    }
}

