/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.os3;

import com.mcmoddev.orespawn.api.IDimensionList;
import com.mcmoddev.orespawn.api.os3.IDimensionBuilder;
import com.mcmoddev.orespawn.impl.os3.DimensionList;
import com.mcmoddev.orespawn.impl.os3.DimensionListAcceptAll;
import com.mcmoddev.orespawn.impl.os3.DimensionListAcceptAllOverworld;
import com.mcmoddev.orespawn.impl.os3.DimensionListDenyAll;
import java.util.LinkedList;
import java.util.List;

public class DimensionBuilder
implements IDimensionBuilder {
    private final List<Integer> dimensionWhitelist = new LinkedList<Integer>();
    private final List<Integer> dimensionBlacklist = new LinkedList<Integer>();
    private boolean acceptAll = false;
    private boolean denyAll = false;
    private boolean acceptAllOverworld = true;

    @Override
    public IDimensionBuilder addWhitelistEntry(int dimensionID) {
        this.acceptAllOverworld = false;
        this.dimensionWhitelist.add(dimensionID);
        return this;
    }

    @Override
    public IDimensionBuilder addBlacklistEntry(int dimensionID) {
        this.acceptAllOverworld = false;
        this.dimensionBlacklist.add(dimensionID);
        return this;
    }

    @Override
    public IDimensionBuilder setAcceptAll() {
        if (this.denyAll) {
            this.denyAll = false;
        }
        this.acceptAll = true;
        return this;
    }

    @Override
    public IDimensionBuilder setDenyAll() {
        if (this.acceptAll) {
            this.acceptAll = false;
        }
        this.denyAll = true;
        return this;
    }

    @Override
    public IDimensionList create() {
        if (this.acceptAll || this.dimensionWhitelist.isEmpty() && this.dimensionBlacklist.isEmpty() && !this.acceptAllOverworld) {
            return new DimensionListAcceptAll();
        }
        if (this.denyAll) {
            return new DimensionListDenyAll();
        }
        if (this.acceptAllOverworld) {
            return new DimensionListAcceptAllOverworld();
        }
        return new DimensionList(this.dimensionWhitelist, this.dimensionBlacklist);
    }

    @Override
    public IDimensionBuilder setAcceptAllOverworld() {
        this.acceptAll = false;
        this.denyAll = false;
        this.acceptAllOverworld = true;
        return this;
    }
}

