/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutablePickupDelayData;
import org.spongepowered.api.data.manipulator.mutable.entity.PickupDelayData;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongePickupDelayData;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public final class ImmutableSpongePickupDelayData
extends AbstractImmutableData<ImmutablePickupDelayData, PickupDelayData>
implements ImmutablePickupDelayData {
    private final int value;

    public ImmutableSpongePickupDelayData(int value) {
        super(ImmutablePickupDelayData.class);
        this.value = value;
        this.registerGetters();
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.INFINITE_PICKUP_DELAY, this::isInifinitePickup);
        this.registerKeyValue(Keys.INFINITE_PICKUP_DELAY, this::infinite);
        this.registerFieldGetter(Keys.PICKUP_DELAY, this::getDelay);
        this.registerKeyValue(Keys.PICKUP_DELAY, this::delay);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.PICKUP_DELAY, (Object)this.value).set(Keys.INFINITE_PICKUP_DELAY, (Object)this.isInifinitePickup());
    }

    @Override
    public ImmutableBoundedValue<Integer> delay() {
        return SpongeValueFactory.boundedBuilder(Keys.PICKUP_DELAY).actualValue(this.value).minimum((Integer)Short.MIN_VALUE).maximum((Integer)Short.MAX_VALUE).defaultValue(0).build().asImmutable();
    }

    private int getDelay() {
        return this.value;
    }

    @Override
    public ImmutableValue<Boolean> infinite() {
        return new ImmutableSpongeValue<Boolean>(Keys.INFINITE_PICKUP_DELAY, false, this.isInifinitePickup());
    }

    private boolean isInifinitePickup() {
        return this.value == Short.MAX_VALUE;
    }

    @Override
    public PickupDelayData asMutable() {
        return new SpongePickupDelayData(this.value);
    }
}

