/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.tileentity;

import java.util.Optional;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemRecord;
import org.spongepowered.api.block.tileentity.Jukebox;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableRepresentedItemData;
import org.spongepowered.api.data.manipulator.mutable.RepresentedItemData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.data.manipulator.mutable.SpongeRepresentedItemData;
import org.spongepowered.common.data.processor.common.AbstractTileEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.registry.type.ItemTypeRegistryModule;

public class JukeboxDataProcessor
extends AbstractTileEntitySingleDataProcessor<BlockJukebox.TileEntityJukebox, ItemStackSnapshot, Value<ItemStackSnapshot>, RepresentedItemData, ImmutableRepresentedItemData> {
    public JukeboxDataProcessor() {
        super(BlockJukebox.TileEntityJukebox.class, Keys.REPRESENTED_ITEM);
    }

    @Override
    protected boolean set(BlockJukebox.TileEntityJukebox jukebox, ItemStackSnapshot stackSnapshot) {
        IBlockState block = jukebox.func_145831_w().func_180495_p(jukebox.func_174877_v());
        if (stackSnapshot == ItemStackSnapshot.NONE) {
            if (jukebox.func_145856_a() == null) {
                return true;
            }
            return this.remove(jukebox);
        }
        if (!(stackSnapshot.getType() instanceof ItemRecord)) {
            return false;
        }
        ((Jukebox)jukebox).insertRecord(stackSnapshot.createStack());
        block = jukebox.func_145831_w().func_180495_p(jukebox.func_174877_v());
        return block.func_177230_c() instanceof BlockJukebox && (Boolean)block.func_177229_b((IProperty)BlockJukebox.field_176432_a) != false;
    }

    @Override
    protected Optional<ItemStackSnapshot> getVal(BlockJukebox.TileEntityJukebox jukebox) {
        if (jukebox.func_145856_a() == null) {
            return Optional.empty();
        }
        return Optional.of(((ItemStack)jukebox.func_145856_a()).createSnapshot());
    }

    private boolean remove(BlockJukebox.TileEntityJukebox jukebox) {
        ((Jukebox)jukebox).ejectRecord();
        IBlockState block = jukebox.func_145831_w().func_180495_p(jukebox.func_174877_v());
        return block.func_177230_c() instanceof BlockJukebox && (Boolean)block.func_177229_b((IProperty)BlockJukebox.field_176432_a) == false;
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (!(container instanceof BlockJukebox.TileEntityJukebox)) {
            return DataTransactionResult.failNoData();
        }
        BlockJukebox.TileEntityJukebox jukebox = (BlockJukebox.TileEntityJukebox)container;
        Optional<ItemStackSnapshot> old = this.getVal(jukebox);
        if (!old.isPresent()) {
            return DataTransactionResult.successNoData();
        }
        if (this.remove(jukebox)) {
            return DataTransactionResult.successRemove(this.constructImmutableValue(old.get()));
        }
        return DataTransactionResult.builder().result(DataTransactionResult.Type.ERROR).build();
    }

    @Override
    protected RepresentedItemData createManipulator() {
        return new SpongeRepresentedItemData();
    }

    @Override
    protected Value<ItemStackSnapshot> constructValue(ItemStackSnapshot value) {
        return new SpongeValue<ItemStackSnapshot>(Keys.REPRESENTED_ITEM, ItemTypeRegistryModule.getInstance().NONE_SNAPSHOT, value);
    }

    @Override
    protected ImmutableValue<ItemStackSnapshot> constructImmutableValue(ItemStackSnapshot value) {
        return new ImmutableSpongeValue<ItemStackSnapshot>(Keys.REPRESENTED_ITEM, ItemTypeRegistryModule.getInstance().NONE_SNAPSHOT, value);
    }
}

