/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.item.EntityMinecartCommandBlock;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableCommandData;
import org.spongepowered.api.data.manipulator.mutable.CommandData;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.data.manipulator.mutable.SpongeCommandData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.mixin.core.tileentity.CommandBlockBaseLogicAccessor;
import org.spongepowered.common.text.SpongeTexts;

public class EntityCommandDataProcessor
extends AbstractEntityDataProcessor<EntityMinecartCommandBlock, CommandData, ImmutableCommandData> {
    public EntityCommandDataProcessor() {
        super(EntityMinecartCommandBlock.class);
    }

    @Override
    public Optional<CommandData> fill(DataContainer container, CommandData commandData) {
        if (!container.contains(Keys.LAST_COMMAND_OUTPUT.getQuery(), Keys.SUCCESS_COUNT.getQuery(), Keys.COMMAND.getQuery(), Keys.TRACKS_OUTPUT.getQuery())) {
            return Optional.empty();
        }
        LiteralText lastCommandOutput = Text.of(container.getString(Keys.LAST_COMMAND_OUTPUT.getQuery()).get());
        int successCount = container.getInt(Keys.SUCCESS_COUNT.getQuery()).get();
        String command = container.getString(Keys.COMMAND.getQuery()).get();
        boolean tracksOutput = container.getBoolean(Keys.TRACKS_OUTPUT.getQuery()).get();
        commandData.set(Keys.LAST_COMMAND_OUTPUT, Optional.of(lastCommandOutput));
        commandData.set(Keys.SUCCESS_COUNT, successCount);
        commandData.set(Keys.COMMAND, command);
        commandData.set(Keys.TRACKS_OUTPUT, tracksOutput);
        return Optional.of(commandData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected boolean doesDataExist(EntityMinecartCommandBlock entity) {
        return true;
    }

    @Override
    protected boolean set(EntityMinecartCommandBlock entity, Map<Key<?>, Object> keyValues) {
        CommandBlockBaseLogic logic = entity.func_145822_e();
        logic.func_145750_b(SpongeTexts.toComponent(((Optional)keyValues.get(Keys.LAST_COMMAND_OUTPUT)).orElse(Text.of())));
        ((CommandBlockBaseLogicAccessor)logic).accessor$setCommandStored((String)keyValues.get(Keys.COMMAND));
        ((CommandBlockBaseLogicAccessor)logic).accessor$setSuccessCount((Integer)keyValues.get(Keys.SUCCESS_COUNT));
        logic.func_175573_a(((Boolean)keyValues.get(Keys.TRACKS_OUTPUT)).booleanValue());
        entity.func_70071_h_();
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityMinecartCommandBlock entity) {
        CommandBlockBaseLogic logic = entity.func_145822_e();
        HashMap values = Maps.newHashMapWithExpectedSize((int)4);
        Optional lastCommandOutput = logic.func_145749_h() != null ? Optional.of(SpongeTexts.toText(logic.func_145749_h())) : Optional.empty();
        values.put(Keys.LAST_COMMAND_OUTPUT, lastCommandOutput);
        values.put(Keys.COMMAND, logic.func_145753_i());
        values.put(Keys.SUCCESS_COUNT, logic.func_145760_g());
        values.put(Keys.TRACKS_OUTPUT, logic.func_175571_m());
        return values;
    }

    @Override
    protected CommandData createManipulator() {
        return new SpongeCommandData();
    }
}

