/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.item.EntityArmorStand;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.SetValue;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.item.inventory.equipment.WornEquipmentType;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeSetValue;
import org.spongepowered.common.mixin.core.entity.item.EntityArmorStandAccessor;

public class PlacingDisabledValueProcessor
extends AbstractSpongeValueProcessor<EntityArmorStand, Set<EquipmentType>, SetValue<EquipmentType>> {
    public PlacingDisabledValueProcessor() {
        super(EntityArmorStand.class, Keys.ARMOR_STAND_TAKING_DISABLED);
    }

    @Override
    public DataTransactionResult offerToStore(ValueContainer<?> container, Set<EquipmentType> value) {
        try {
            this.set((EntityArmorStand)container, value);
            return DataTransactionResult.successNoData();
        }
        catch (Exception e) {
            return DataTransactionResult.failNoData();
        }
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected SetValue<EquipmentType> constructValue(Set<EquipmentType> actualValue) {
        return new SpongeSetValue<EquipmentType>(this.key, actualValue);
    }

    @Override
    protected boolean set(EntityArmorStand container, Set<EquipmentType> value) {
        int chunk = 0;
        int disabledSlots = ((EntityArmorStandAccessor)container).accessor$getDisabledSlots();
        int allChunk = disabledSlots & 0xFF;
        if (allChunk != 0) {
            disabledSlots |= allChunk << 16;
            disabledSlots ^= 0xFF;
        }
        if (value.contains(EquipmentTypes.BOOTS)) {
            chunk |= 2;
        }
        if (value.contains(EquipmentTypes.LEGGINGS)) {
            chunk |= 4;
        }
        if (value.contains(EquipmentTypes.CHESTPLATE)) {
            chunk |= 8;
        }
        if (value.contains(EquipmentTypes.HEADWEAR)) {
            chunk |= 0x10;
        }
        ((EntityArmorStandAccessor)container).accessor$setDisabledSlots(disabledSlots |= chunk << 816);
        return true;
    }

    @Override
    protected Optional<Set<EquipmentType>> getVal(EntityArmorStand container) {
        int disabled = ((EntityArmorStandAccessor)container).accessor$getDisabledSlots();
        int resultantChunk = disabled >> 16 & 0xFF | disabled & 0xFF;
        HashSet<WornEquipmentType> val = new HashSet<WornEquipmentType>();
        if ((resultantChunk & 2) != 0) {
            val.add(EquipmentTypes.BOOTS);
        }
        if ((resultantChunk & 4) != 0) {
            val.add(EquipmentTypes.LEGGINGS);
        }
        if ((resultantChunk & 8) != 0) {
            val.add(EquipmentTypes.CHESTPLATE);
        }
        if ((resultantChunk & 0x10) != 0) {
            val.add(EquipmentTypes.HEADWEAR);
        }
        return Optional.of(val);
    }

    @Override
    protected ImmutableValue<Set<EquipmentType>> constructImmutableValue(Set<EquipmentType> value) {
        return ImmutableSpongeValue.cachedOf(this.key, Collections.emptySet(), value);
    }
}

