/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import co.aikar.timings.Timing;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.BlockRedstoneLight;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.TickBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.bridge.OwnershipTrackedBridge;
import org.spongepowered.common.bridge.TimingBridge;
import org.spongepowered.common.bridge.block.BlockEventDataBridge;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.tileentity.TileEntityBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.bridge.world.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.ItemDropData;
import org.spongepowered.common.event.tracking.context.MultiBlockCaptureSupplier;
import org.spongepowered.common.event.tracking.phase.tick.BlockEventTickContext;
import org.spongepowered.common.event.tracking.phase.tick.BlockTickContext;
import org.spongepowered.common.event.tracking.phase.tick.DimensionContext;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.event.tracking.phase.tick.TileEntityTickContext;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.common.world.SpongeLocatableBlockBuilder;

public final class TrackingUtil {
    public static final int BREAK_BLOCK_INDEX = BlockChange.BREAK.ordinal();
    public static final int PLACE_BLOCK_INDEX = BlockChange.PLACE.ordinal();
    public static final int DECAY_BLOCK_INDEX = BlockChange.DECAY.ordinal();
    public static final int CHANGE_BLOCK_INDEX = BlockChange.MODIFY.ordinal();
    private static final int MULTI_CHANGE_INDEX = BlockChange.values().length;
    private static final int EVENT_COUNT = BlockChange.values().length + 1;
    private static final Function<ImmutableList.Builder<Transaction<BlockSnapshot>>[], Consumer<Transaction<BlockSnapshot>>> TRANSACTION_PROCESSOR = builders -> transaction -> {
        BlockChange blockChange = ((SpongeBlockSnapshot)transaction.getOriginal()).blockChange;
        builders[blockChange.ordinal()].add(transaction);
        builders[MULTI_CHANGE_INDEX].add(transaction);
    };
    static final Function<SpongeBlockSnapshot, Optional<Transaction<BlockSnapshot>>> TRANSACTION_CREATION = blockSnapshot -> blockSnapshot.getWorldServer().map(worldServer -> {
        BlockPos targetPos = blockSnapshot.getBlockPos();
        SpongeBlockSnapshot replacement = ((WorldServerBridge)worldServer).bridge$createSnapshot(targetPos, BlockChangeFlags.NONE);
        return new Transaction<SpongeBlockSnapshot>((SpongeBlockSnapshot)blockSnapshot, replacement);
    });
    public static final int WIDTH = 40;

    public static void tickEntity(net.minecraft.entity.Entity entity) {
        Preconditions.checkArgument((boolean)(entity instanceof Entity), (String)"Entity %s is not an instance of SpongeAPI's Entity!", (Object)entity);
        Preconditions.checkNotNull((Object)entity, (Object)"Cannot capture on a null ticking entity!");
        EntityBridge mixinEntity = (EntityBridge)entity;
        if (!mixinEntity.bridge$shouldTick()) {
            return;
        }
        EntityTickContext tickContext = TickPhase.Tick.ENTITY.createPhaseContext().source(entity);
        try (EntityTickContext context = tickContext;
             Timing entityTiming = ((TimingBridge)entity).bridge$getTimingsHandler();){
            if (entity instanceof OwnershipTrackedBridge) {
                ((OwnershipTrackedBridge)entity).tracked$getNotifierReference().ifPresent(context::notifier);
                ((OwnershipTrackedBridge)entity).tracked$getOwnerReference().ifPresent(context::owner);
            }
            context.buildAndSwitch();
            entityTiming.startTiming();
            entity.func_70071_h_();
            if (ShouldFire.MOVE_ENTITY_EVENT_POSITION || ShouldFire.ROTATE_ENTITY_EVENT) {
                SpongeCommonEventFactory.callMoveEntityEvent(entity, context);
            }
        }
        catch (Exception | NoClassDefFoundError e) {
            PhaseTracker.getInstance().printExceptionFromPhase(e, tickContext);
        }
    }

    public static void tickRidingEntity(net.minecraft.entity.Entity entity) {
        Preconditions.checkArgument((boolean)(entity instanceof Entity), (String)"Entity %s is not an instance of SpongeAPI's Entity!", (Object)entity);
        Preconditions.checkNotNull((Object)entity, (Object)"Cannot capture on a null ticking entity!");
        EntityBridge mixinEntity = (EntityBridge)entity;
        if (!mixinEntity.bridge$shouldTick()) {
            return;
        }
        EntityTickContext tickContext = TickPhase.Tick.ENTITY.createPhaseContext().source(entity);
        try (EntityTickContext context = tickContext;
             Timing entityTiming = ((TimingBridge)entity).bridge$getTimingsHandler();){
            entityTiming.startTiming();
            if (entity instanceof OwnershipTrackedBridge) {
                ((OwnershipTrackedBridge)entity).tracked$getNotifierReference().ifPresent(context::notifier);
                ((OwnershipTrackedBridge)entity).tracked$getOwnerReference().ifPresent(context::owner);
            }
            context.buildAndSwitch();
            entity.func_70098_U();
            if (ShouldFire.MOVE_ENTITY_EVENT_POSITION || ShouldFire.ROTATE_ENTITY_EVENT) {
                SpongeCommonEventFactory.callMoveEntityEvent(entity, context);
            }
        }
        catch (Exception | NoClassDefFoundError e) {
            PhaseTracker.getInstance().printExceptionFromPhase(e, tickContext);
        }
    }

    public static void tickTileEntity(WorldServerBridge mixinWorldServer, ITickable tile) {
        Preconditions.checkArgument((boolean)(tile instanceof org.spongepowered.api.block.tileentity.TileEntity), (String)"ITickable %s is not a TileEntity!", (Object)tile);
        Preconditions.checkNotNull((Object)tile, (Object)"Cannot capture on a null ticking tile entity!");
        TileEntity tileEntity = (TileEntity)tile;
        TileEntityBridge mixinTileEntity = (TileEntityBridge)tile;
        BlockPos pos = tileEntity.func_174877_v();
        ChunkBridge chunk = ((ActiveChunkReferantBridge)tile).bridge$getActiveChunk();
        if (!mixinTileEntity.bridge$shouldTick()) {
            return;
        }
        if (chunk == null) {
            ((ActiveChunkReferantBridge)tile).bridge$setActiveChunk((ChunkBridge)tileEntity.func_145831_w().func_175726_f(tileEntity.func_174877_v()));
        }
        TileEntityTickContext context = TickPhase.Tick.TILE_ENTITY.createPhaseContext().source(mixinTileEntity);
        try (TileEntityTickContext phaseContext = context;){
            if (tile instanceof OwnershipTrackedBridge) {
                ((OwnershipTrackedBridge)tile).tracked$getNotifierReference().ifPresent(phaseContext::notifier);
                ((OwnershipTrackedBridge)tile).tracked$getOwnerReference().ifPresent(phaseContext::owner);
            }
            phaseContext.buildAndSwitch();
            try (Timing timing = ((TimingBridge)tileEntity).bridge$getTimingsHandler().startTiming();){
                tile.func_73660_a();
            }
        }
        catch (Exception e) {
            PhaseTracker.getInstance().printExceptionFromPhase(e, context);
        }
        if (tileEntity.func_145837_r()) {
            ((ActiveChunkReferantBridge)tileEntity).bridge$setActiveChunk(null);
        }
    }

    public static void updateTickBlock(WorldServerBridge mixinWorld, Block block, BlockPos pos, IBlockState state, Random random) {
        WorldServer world = (WorldServer)mixinWorld;
        World apiWorld = (World)world;
        if (ShouldFire.TICK_BLOCK_EVENT) {
            SpongeBlockSnapshot snapshot = mixinWorld.bridge$createSnapshot(state, state, pos, BlockChangeFlags.NONE);
            TickBlockEvent.Scheduled event = SpongeEventFactory.createTickBlockEventScheduled(Sponge.getCauseStackManager().getCurrentCause(), snapshot);
            SpongeImpl.postEvent(event);
            if (event.isCancelled()) {
                return;
            }
        }
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world(apiWorld).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).state((BlockState)state).build();
        BlockTickContext phaseContext = TickPhase.Tick.BLOCK.createPhaseContext().source(locatable);
        PhaseContext<?> currentContext = PhaseTracker.getInstance().getCurrentContext();
        IPhaseState currentState = currentContext.state;
        currentState.appendNotifierPreBlockTick(mixinWorld, pos, currentContext, phaseContext);
        try (BlockTickContext context = phaseContext;
             Timing timing = ((TimingBridge)state.func_177230_c()).bridge$getTimingsHandler();){
            timing.startTiming();
            context.buildAndSwitch();
            block.func_180650_b((net.minecraft.world.World)world, pos, state, random);
        }
        catch (Exception | NoClassDefFoundError e) {
            PhaseTracker.getInstance().printExceptionFromPhase(e, phaseContext);
        }
    }

    public static void randomTickBlock(WorldServerBridge mixinWorld, Block block, BlockPos pos, IBlockState state, Random random) {
        WorldServer world = (WorldServer)mixinWorld;
        World apiWorld = (World)world;
        if (ShouldFire.TICK_BLOCK_EVENT) {
            SpongeBlockSnapshot currentTickBlock = mixinWorld.bridge$createSnapshot(state, state, pos, BlockChangeFlags.NONE);
            TickBlockEvent.Random event = SpongeEventFactory.createTickBlockEventRandom(Sponge.getCauseStackManager().getCurrentCause(), currentTickBlock);
            SpongeImpl.postEvent(event);
            if (event.isCancelled()) {
                return;
            }
        }
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world(apiWorld).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).state((BlockState)state).build();
        BlockTickContext phaseContext = TickPhase.Tick.RANDOM_BLOCK.createPhaseContext().source(locatable);
        PhaseContext<?> currentContext = PhaseTracker.getInstance().getCurrentContext();
        IPhaseState currentState = currentContext.state;
        currentState.appendNotifierPreBlockTick(mixinWorld, pos, currentContext, phaseContext);
        try (BlockTickContext context = phaseContext;){
            context.buildAndSwitch();
            block.func_180645_a((net.minecraft.world.World)world, pos, state, random);
        }
        catch (Exception | NoClassDefFoundError e) {
            PhaseTracker.getInstance().printExceptionFromPhase(e, phaseContext);
        }
    }

    public static void tickWorldProvider(WorldServerBridge worldServer) {
        WorldProvider worldProvider = ((WorldServer)worldServer).field_73011_w;
        try (DimensionContext context = (DimensionContext)TickPhase.Tick.DIMENSION.createPhaseContext().source(worldProvider);){
            context.buildAndSwitch();
            worldProvider.func_186059_r();
        }
    }

    public static boolean fireMinecraftBlockEvent(WorldServer worldIn, BlockEventData event) {
        DataSerializable source;
        IBlockState currentState = worldIn.func_180495_p(event.func_180328_a());
        BlockEventDataBridge blockEvent = (BlockEventDataBridge)event;
        DataSerializable dataSerializable = source = blockEvent.bridge$getTileEntity() != null ? blockEvent.bridge$getTileEntity() : blockEvent.bridge$getTickingLocatable();
        if (source == null) {
            return currentState.func_189547_a((net.minecraft.world.World)worldIn, event.func_180328_a(), event.func_151339_d(), event.func_151338_e());
        }
        BlockEventTickContext phaseContext = TickPhase.Tick.BLOCK_EVENT.createPhaseContext();
        phaseContext.source(source);
        User user = ((BlockEventDataBridge)event).bridge$getSourceUser();
        if (user != null) {
            phaseContext.owner = user;
            phaseContext.notifier = user;
        }
        boolean result = true;
        try (BlockEventTickContext o = phaseContext;){
            o.buildAndSwitch();
            phaseContext.setEventSucceeded(currentState.func_189547_a((net.minecraft.world.World)worldIn, event.func_180328_a(), event.func_151339_d(), event.func_151338_e()));
            result = phaseContext.wasNotCancelled();
        }
        return result;
    }

    static boolean forceModify(Block originalBlock, Block newBlock) {
        if (originalBlock instanceof BlockRedstoneRepeater && newBlock instanceof BlockRedstoneRepeater) {
            return true;
        }
        if (originalBlock instanceof BlockRedstoneTorch && newBlock instanceof BlockRedstoneTorch) {
            return true;
        }
        return originalBlock instanceof BlockRedstoneLight && newBlock instanceof BlockRedstoneLight;
    }

    private TrackingUtil() {
    }

    @Nullable
    public static User getNotifierOrOwnerFromBlock(WorldServer world, BlockPos blockPos) {
        ChunkBridge mixinChunk = (ChunkBridge)world.func_175726_f(blockPos);
        User notifier = mixinChunk.bridge$getBlockNotifier(blockPos).orElse(null);
        if (notifier != null) {
            return notifier;
        }
        return mixinChunk.bridge$getBlockOwner(blockPos).orElse(null);
    }

    public static Supplier<IllegalStateException> throwWithContext(String s, PhaseContext<?> phaseContext) {
        return () -> {
            PrettyPrinter printer = new PrettyPrinter(60);
            printer.add("Exception trying to process over a phase!").centre().hr();
            printer.addWrapped(40, "%s : %s", "State", phaseContext.state);
            printer.addWrapped(40, "%s :", "PhaseContext");
            PhaseTracker.CONTEXT_PRINTER.accept(printer, phaseContext);
            printer.add("Stacktrace:");
            IllegalStateException exception = new IllegalStateException(s + " Please analyze the current phase context. ");
            printer.add(exception);
            printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
            return exception;
        };
    }

    public static boolean processBlockCaptures(PhaseContext<?> context) {
        return TrackingUtil.processBlockCaptures(context, 0, context.getCapturedBlockSupplier());
    }

    static boolean processBlockCaptures(PhaseContext<?> context, int currentDepth, MultiBlockCaptureSupplier supplier) {
        if (!supplier.hasBlocksCaptured()) {
            if (context.state.hasSpecificBlockProcess(context) && supplier.hasTransactions()) {
                ListMultimap<BlockPos, BlockEventData> scheduledEvents = supplier.getScheduledEvents();
                supplier.clear();
                return supplier.processTransactions((List<Transaction<BlockSnapshot>>)ImmutableList.of(), context, true, scheduledEvents, currentDepth);
            }
            return false;
        }
        ArrayList<ChangeBlockEvent> blockEvents = new ArrayList<ChangeBlockEvent>();
        ImmutableList[] transactionArrays = new ImmutableList[EVENT_COUNT];
        ImmutableList.Builder[] transactionBuilders = new ImmutableList.Builder[EVENT_COUNT];
        for (int i = 0; i < EVENT_COUNT; ++i) {
            transactionBuilders[i] = new ImmutableList.Builder();
        }
        TrackingUtil.createTransactionLists(context, supplier, transactionArrays, transactionBuilders);
        ListMultimap<BlockPos, BlockEventData> scheduledEvents = supplier.getScheduledEvents();
        supplier.clear();
        ChangeBlockEvent[] mainEvents = new ChangeBlockEvent[BlockChange.values().length];
        TrackingUtil.iterateChangeBlockEvents(transactionArrays, blockEvents, mainEvents);
        ChangeBlockEvent.Post postEvent = TrackingUtil.throwMultiEventsAndCreatePost(context, transactionArrays, blockEvents, mainEvents);
        if (postEvent == null) {
            return false;
        }
        ArrayList<Transaction<BlockSnapshot>> invalid = new ArrayList<Transaction<BlockSnapshot>>();
        boolean noCancelledTransactions = TrackingUtil.checkCancelledEvents(blockEvents, postEvent, scheduledEvents, context, invalid);
        TrackingUtil.clearInvalidTransactionDrops(context, postEvent);
        if (!invalid.isEmpty()) {
            noCancelledTransactions = false;
            TrackingUtil.rollBackTransactions(context, invalid);
            invalid.clear();
        }
        return TrackingUtil.performBlockAdditions(postEvent.getTransactions(), context, noCancelledTransactions, scheduledEvents, currentDepth);
    }

    private static void createTransactionLists(PhaseContext<?> context, MultiBlockCaptureSupplier supplier, ImmutableList<Transaction<BlockSnapshot>>[] transactionArrays, ImmutableList.Builder<Transaction<BlockSnapshot>>[] transactionBuilders) {
        List<SpongeBlockSnapshot> snapshots = supplier.get();
        for (SpongeBlockSnapshot snapshot : snapshots) {
            context.getCapturedBlockSupplier().createTransaction(snapshot).ifPresent(transaction -> TRANSACTION_PROCESSOR.apply(transactionBuilders).accept((Transaction<BlockSnapshot>)transaction));
        }
        for (int i = 0; i < EVENT_COUNT; ++i) {
            transactionArrays[i] = transactionBuilders[i].build();
        }
    }

    private static boolean checkCancelledEvents(List<ChangeBlockEvent> blockEvents, ChangeBlockEvent.Post postEvent, ListMultimap<BlockPos, BlockEventData> scheduledEvents, PhaseContext<?> context, List<Transaction<BlockSnapshot>> invalid) {
        boolean noCancelledTransactions = true;
        for (ChangeBlockEvent changeBlockEvent : blockEvents) {
            if (!changeBlockEvent.isCancelled()) continue;
            noCancelledTransactions = false;
            for (Transaction transaction : Lists.reverse(changeBlockEvent.getTransactions())) {
                if (!scheduledEvents.isEmpty()) {
                    scheduledEvents.removeAll((Object)VecHelper.toBlockPos(((BlockSnapshot)transaction.getOriginal()).getPosition()));
                }
                transaction.setValid(false);
            }
        }
        if (postEvent.isCancelled()) {
            noCancelledTransactions = false;
            for (Transaction transaction : postEvent.getTransactions()) {
                if (!scheduledEvents.isEmpty()) {
                    scheduledEvents.removeAll((Object)VecHelper.toBlockPos(((BlockSnapshot)transaction.getOriginal()).getPosition()));
                }
                transaction.setValid(false);
            }
        }
        for (Transaction transaction : postEvent.getTransactions()) {
            if (transaction.isValid()) continue;
            noCancelledTransactions = false;
        }
        if (!noCancelledTransactions) {
            boolean cancelAll = context.state.getShouldCancelAllTransactions(context, blockEvents, postEvent, scheduledEvents, false);
            for (Transaction<BlockSnapshot> transaction : postEvent.getTransactions()) {
                if (cancelAll) {
                    if (!scheduledEvents.isEmpty()) {
                        scheduledEvents.removeAll((Object)VecHelper.toBlockPos(transaction.getOriginal().getPosition()));
                    }
                    transaction.setValid(false);
                    noCancelledTransactions = false;
                }
                if (transaction.isValid()) continue;
                invalid.add(transaction);
            }
        }
        return noCancelledTransactions;
    }

    private static void clearInvalidTransactionDrops(PhaseContext<?> context, ChangeBlockEvent.Post postEvent) {
        for (Transaction<BlockSnapshot> transaction : postEvent.getTransactions()) {
            if (transaction.isValid() || !(transaction.getOriginal() instanceof SpongeBlockSnapshot)) continue;
            BlockPos pos = ((SpongeBlockSnapshot)transaction.getOriginal()).getBlockPos();
            context.getBlockItemDropSupplier().removeAllIfNotEmpty(pos);
            context.getPerBlockEntitySpawnSuppplier().removeAllIfNotEmpty(pos);
        }
    }

    private static void rollBackTransactions(PhaseContext<?> context, List<Transaction<BlockSnapshot>> invalid) {
        for (Transaction transaction : Lists.reverse(invalid)) {
            ((BlockSnapshot)transaction.getOriginal()).restore(true, BlockChangeFlags.NONE);
            context.state.processCancelledTransaction(context, transaction, (BlockSnapshot)transaction.getOriginal());
        }
    }

    private static void iterateChangeBlockEvents(ImmutableList<Transaction<BlockSnapshot>>[] transactionArrays, List<ChangeBlockEvent> blockEvents, ChangeBlockEvent[] mainEvents) {
        for (BlockChange blockChange : BlockChange.values()) {
            ChangeBlockEvent event;
            if (blockChange == BlockChange.DECAY || transactionArrays[blockChange.ordinal()].isEmpty()) continue;
            mainEvents[blockChange.ordinal()] = event = blockChange.createEvent(Sponge.getCauseStackManager().getCurrentCause(), transactionArrays[blockChange.ordinal()]);
            SpongeImpl.postEvent(event);
            blockEvents.add(event);
        }
        if (!transactionArrays[BlockChange.DECAY.ordinal()].isEmpty()) {
            ChangeBlockEvent event;
            mainEvents[BlockChange.DECAY.ordinal()] = event = BlockChange.DECAY.createEvent(Sponge.getCauseStackManager().getCurrentCause(), transactionArrays[BlockChange.DECAY.ordinal()]);
            SpongeImpl.postEvent(event);
            blockEvents.add(event);
        }
    }

    private static boolean performBlockAdditions(List<Transaction<BlockSnapshot>> transactions, PhaseContext<?> phaseContext, boolean noCancelledTransactions, ListMultimap<BlockPos, BlockEventData> scheduledEvents, int currentDepth) {
        boolean hasEvents = false;
        if (!scheduledEvents.isEmpty()) {
            hasEvents = true;
        }
        if (phaseContext.state.hasSpecificBlockProcess(phaseContext)) {
            return phaseContext.getCapturedBlockSupplier().processTransactions(transactions, phaseContext, noCancelledTransactions, scheduledEvents, currentDepth);
        }
        for (Transaction<BlockSnapshot> transaction : transactions) {
            if (!transaction.isValid()) continue;
            TrackingUtil.performTransactionProcess(transaction, phaseContext, currentDepth);
        }
        phaseContext.getCapturedBlockSupplier().clearProxies();
        return noCancelledTransactions;
    }

    public static void performTransactionProcess(Transaction<BlockSnapshot> transaction, PhaseContext<?> phaseContext, int currentDepth) {
        if (transaction.getCustom().isPresent()) {
            transaction.getFinal().restore(true, BlockChangeFlags.NONE);
        }
        SpongeBlockSnapshot oldBlockSnapshot = (SpongeBlockSnapshot)transaction.getOriginal();
        SpongeBlockSnapshot newBlockSnapshot = (SpongeBlockSnapshot)transaction.getFinal();
        Optional<WorldServer> worldServer = oldBlockSnapshot.getWorldServer();
        if (!worldServer.isPresent()) {
            String transactionForLogging = MoreObjects.toStringHelper((String)"Transaction").add("World", (Object)oldBlockSnapshot.getWorldUniqueId()).add("Position", (Object)oldBlockSnapshot.getBlockPos()).add("Original State", (Object)oldBlockSnapshot.getState()).add("Changed State", (Object)newBlockSnapshot.getState()).toString();
            SpongeImpl.getLogger().warn("Unloaded/Missing World for a captured block change! Skipping change: " + transactionForLogging);
            return;
        }
        WorldServerBridge mixinWorld = (WorldServerBridge)worldServer.get();
        BlockPos pos = oldBlockSnapshot.getBlockPos();
        TrackingUtil.performBlockEntitySpawns(phaseContext.state, phaseContext, oldBlockSnapshot, pos);
        WorldServer world = (WorldServer)mixinWorld;
        SpongeHooks.logBlockAction((net.minecraft.world.World)world, oldBlockSnapshot.blockChange, transaction);
        SpongeBlockChangeFlag originalChangeFlag = oldBlockSnapshot.getChangeFlag();
        IBlockState originalState = (IBlockState)oldBlockSnapshot.getState();
        IBlockState newState = (IBlockState)newBlockSnapshot.getState();
        if (transaction.getIntermediary().isEmpty()) {
            TrackingUtil.performOnBlockAdded(phaseContext, currentDepth, pos, world, originalChangeFlag, originalState, newState);
            phaseContext.state.postBlockTransactionApplication(oldBlockSnapshot.blockChange, transaction, phaseContext);
            if (originalChangeFlag.isNotifyClients()) {
                world.func_184138_a(pos, originalState, newState, originalChangeFlag.getRawFlag());
            }
            TrackingUtil.performNeighborAndClientNotifications(phaseContext, currentDepth, newBlockSnapshot, mixinWorld, pos, newState, originalChangeFlag);
        }
        IBlockState previousIntermediary = originalState;
        boolean processedOriginal = false;
        Iterator<BlockSnapshot> iterator = transaction.getIntermediary().iterator();
        while (iterator.hasNext()) {
            SpongeBlockSnapshot intermediary = (SpongeBlockSnapshot)iterator.next();
            SpongeBlockChangeFlag intermediaryChangeFlag = intermediary.getChangeFlag();
            IBlockState intermediaryState = (IBlockState)intermediary.getState();
            if (!processedOriginal) {
                TrackingUtil.performOnBlockAdded(phaseContext, currentDepth, pos, world, originalChangeFlag, originalState, intermediaryState);
                if (originalChangeFlag.isNotifyClients()) {
                    world.func_184138_a(pos, originalState, intermediaryState, originalChangeFlag.getRawFlag());
                }
                TrackingUtil.performNeighborAndClientNotifications(phaseContext, currentDepth, intermediary, mixinWorld, pos, intermediaryState, originalChangeFlag);
                processedOriginal = true;
            }
            boolean isFinal = !iterator.hasNext();
            TrackingUtil.performOnBlockAdded(phaseContext, currentDepth, pos, world, intermediaryChangeFlag, isFinal ? intermediaryState : previousIntermediary, isFinal ? newState : intermediaryState);
            if (intermediaryChangeFlag.isNotifyClients()) {
                world.func_184138_a(pos, isFinal ? intermediaryState : previousIntermediary, isFinal ? newState : intermediaryState, intermediaryChangeFlag.getRawFlag());
            }
            TrackingUtil.performNeighborAndClientNotifications(phaseContext, currentDepth, isFinal ? newBlockSnapshot : intermediary, mixinWorld, pos, isFinal ? newState : intermediaryState, intermediaryChangeFlag);
            if (isFinal) {
                return;
            }
            previousIntermediary = intermediaryState;
        }
    }

    private static void performOnBlockAdded(PhaseContext<?> phaseContext, int currentDepth, BlockPos pos, WorldServer world, SpongeBlockChangeFlag changeFlag, IBlockState originalState, IBlockState newState) {
        Block newBlock = newState.func_177230_c();
        if (originalState.func_177230_c() != newBlock && changeFlag.performBlockPhysics() && !SpongeImplHooks.hasBlockTileEntity(newBlock, newState)) {
            newBlock.func_176213_c((net.minecraft.world.World)world, pos, newState);
            phaseContext.state.performOnBlockAddedSpawns(phaseContext, currentDepth + 1);
        }
    }

    public static void performNeighborAndClientNotifications(PhaseContext<?> phaseContext, int currentDepth, SpongeBlockSnapshot newBlockSnapshot, WorldServerBridge mixinWorld, BlockPos pos, IBlockState newState, SpongeBlockChangeFlag changeFlag) {
        Block newBlock = newState.func_177230_c();
        IPhaseState phaseState = phaseContext.state;
        if (changeFlag.updateNeighbors()) {
            PhaseContext<?> context = PhaseTracker.getInstance().getCurrentContext();
            BlockSnapshot previousNeighbor = context.neighborNotificationSource;
            context.neighborNotificationSource = newBlockSnapshot;
            if (changeFlag.updateNeighbors()) {
                ((WorldServer)mixinWorld).func_175722_b(pos, newState.func_177230_c(), changeFlag.notifyObservers());
                if (newState.func_185912_n()) {
                    ((WorldServer)mixinWorld).func_175666_e(pos, newState.func_177230_c());
                }
            }
            context.neighborNotificationSource = previousNeighbor;
        } else if (changeFlag.notifyObservers()) {
            ((net.minecraft.world.World)mixinWorld).func_190522_c(pos, newBlock);
        }
        phaseState.performPostBlockNotificationsAndNeighborUpdates(phaseContext, newState, changeFlag, currentDepth + 1);
    }

    public static void performBlockEntitySpawns(IPhaseState<?> state, PhaseContext<?> phaseContext, SpongeBlockSnapshot oldBlockSnapshot, BlockPos pos) {
        if (state.doesCaptureEntitySpawns() || state.doesCaptureEntityDrops(phaseContext)) {
            phaseContext.getBlockDropSupplier().acceptAndRemoveIfPresent(pos, items -> TrackingUtil.spawnItemDataForBlockDrops(items, oldBlockSnapshot, phaseContext));
            phaseContext.getBlockItemDropSupplier().acceptAndRemoveIfPresent(pos, items -> TrackingUtil.spawnItemEntitiesForBlockDrops(items, oldBlockSnapshot, phaseContext));
            phaseContext.getPerBlockEntitySpawnSuppplier().acceptAndRemoveIfPresent(pos, items -> TrackingUtil.spawnEntitiesForBlock(items, phaseContext));
        }
    }

    private static void spawnItemEntitiesForBlockDrops(Collection<EntityItem> entityItems, BlockSnapshot newBlockSnapshot, PhaseContext<?> phaseContext) {
        List<Entity> itemDrops = entityItems.stream().map(entity -> (Entity)entity).collect(Collectors.toList());
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(newBlockSnapshot);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            phaseContext.applyNotifierIfAvailable(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            SpongeCommonEventFactory.callDropItemDestruct(itemDrops, phaseContext);
        }
    }

    public static void spawnItemDataForBlockDrops(Collection<ItemDropData> itemStacks, BlockSnapshot oldBlockSnapshot, PhaseContext<?> phaseContext) {
        Vector3i position = oldBlockSnapshot.getPosition();
        List itemSnapshots = itemStacks.stream().map(ItemDropData::getStack).map(ItemStackUtil::snapshotOf).collect(Collectors.toList());
        ImmutableList originalSnapshots = ImmutableList.copyOf(itemSnapshots);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(oldBlockSnapshot);
            DropItemEvent.Pre dropItemEventPre = SpongeEventFactory.createDropItemEventPre(frame.getCurrentCause(), (List)originalSnapshots, itemSnapshots);
            SpongeImpl.postEvent(dropItemEventPre);
            if (dropItemEventPre.isCancelled()) {
                return;
            }
        }
        Location<World> worldLocation = oldBlockSnapshot.getLocation().get();
        World world = worldLocation.getExtent();
        WorldServer worldServer = (WorldServer)world;
        List<Entity> itemDrops = itemStacks.stream().map(itemStack -> {
            ItemStack minecraftStack = itemStack.getStack();
            float f = 0.5f;
            double offsetX = (double)(worldServer.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double offsetY = (double)(worldServer.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double offsetZ = (double)(worldServer.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double x = (double)position.getX() + offsetX;
            double y = (double)position.getY() + offsetY;
            double z = (double)position.getZ() + offsetZ;
            EntityItem entityitem = new EntityItem((net.minecraft.world.World)worldServer, x, y, z, minecraftStack);
            entityitem.func_174869_p();
            return entityitem;
        }).map(entity -> (Entity)entity).collect(Collectors.toList());
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(oldBlockSnapshot);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            phaseContext.applyNotifierIfAvailable(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            SpongeCommonEventFactory.callDropItemDestruct(itemDrops, phaseContext);
        }
    }

    private static void spawnEntitiesForBlock(Collection<net.minecraft.entity.Entity> entities, PhaseContext<?> phaseContext) {
        List<Entity> entitiesSpawned = entities.stream().map(entity -> (Entity)entity).collect(Collectors.toList());
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.BLOCK_SPAWNING);
            SpongeCommonEventFactory.callSpawnEntity(entitiesSpawned, phaseContext);
        }
    }

    @Nullable
    private static ChangeBlockEvent.Post throwMultiEventsAndCreatePost(PhaseContext<?> context, ImmutableList<Transaction<BlockSnapshot>>[] transactionArrays, List<ChangeBlockEvent> blockEvents, ChangeBlockEvent[] mainEvents) {
        if (!blockEvents.isEmpty()) {
            Cause causeToUse;
            ImmutableList<Transaction<BlockSnapshot>> transactions = transactionArrays[MULTI_CHANGE_INDEX];
            Cause currentCause = Sponge.getCauseStackManager().getCurrentCause();
            if (context.state.shouldProvideModifiers(context)) {
                Cause.Builder builder = Cause.builder().from(currentCause);
                EventContext.Builder modified = EventContext.builder();
                modified.from(currentCause.getContext());
                for (BlockChange blockChange : BlockChange.values()) {
                    ChangeBlockEvent mainEvent = mainEvents[blockChange.ordinal()];
                    if (mainEvent == null) continue;
                    builder.append(mainEvent);
                    modified.add(blockChange.getKey(), mainEvent);
                }
                causeToUse = builder.build(modified.build());
            } else {
                causeToUse = currentCause;
            }
            ChangeBlockEvent.Post post = context.state.createChangeBlockPostEvent(context, transactions, causeToUse);
            SpongeImpl.postEvent(post);
            return post;
        }
        return null;
    }

    public static void associateTrackerToTarget(BlockChange blockChange, Transaction<? extends BlockSnapshot> transaction, User user) {
        BlockSnapshot finalSnapshot = transaction.getFinal();
        SpongeBlockSnapshot spongeSnapshot = (SpongeBlockSnapshot)finalSnapshot;
        BlockPos pos = spongeSnapshot.getBlockPos();
        Block block = ((IBlockState)spongeSnapshot.getState()).func_177230_c();
        spongeSnapshot.getWorldServer().map(world -> world.func_175726_f(pos)).map(chunk -> (ChunkBridge)chunk).ifPresent(spongeChunk -> {
            PlayerTracker.Type trackerType = blockChange == BlockChange.PLACE ? PlayerTracker.Type.OWNER : PlayerTracker.Type.NOTIFIER;
            spongeChunk.bridge$addTrackedBlockPosition(block, pos, user, trackerType);
        });
    }

    public static void addTileEntityToBuilder(@Nullable TileEntity existing, SpongeBlockSnapshotBuilder builder) {
        org.spongepowered.api.block.tileentity.TileEntity tile = (org.spongepowered.api.block.tileentity.TileEntity)existing;
        for (DataManipulator<?, ?> manipulator : ((CustomDataHolderBridge)((Object)tile)).bridge$getCustomManipulators()) {
            builder.add((DataManipulator)manipulator);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        try {
            existing.func_189515_b(nbt);
            builder.unsafeNbt(nbt);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String phaseStateToString(String type, IPhaseState<?> state) {
        return TrackingUtil.phaseStateToString(type, null, state);
    }

    public static String phaseStateToString(String type, @Nullable String extra, IPhaseState<?> state) {
        String name = state.getClass().getSimpleName();
        name = name.replace("Phase", "");
        name = name.replace("State", "");
        name = name.replace(type, "");
        if (extra == null) {
            return type + "{" + name + "}";
        }
        if (name.isEmpty()) {
            return type + "{" + extra + "}";
        }
        return type + "{" + name + ":" + extra + "}";
    }
}

