/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.collections;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.item.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.collections.DynamicLensCollectionImpl;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotLensProvider;
import org.spongepowered.common.item.inventory.lens.impl.slots.SlotLensImpl;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;

public class SlotCollection
extends DynamicLensCollectionImpl
implements SlotProvider {
    private Builder builder;

    public SlotCollection(int size) {
        this(size, null);
    }

    private SlotCollection(int size, Builder builder) {
        super(size);
        this.builder = builder;
        this.populate();
    }

    private void populate() {
        for (int index = 0; index < this.size(); ++index) {
            this.lenses[index] = this.createSlotLens(index);
        }
    }

    private SlotLens createSlotLens(int slotIndex) {
        return this.builder == null ? new SlotLensImpl(slotIndex, SlotAdapter.class) : this.builder.getProvider(slotIndex).createSlotLens(slotIndex);
    }

    @Override
    public SlotLens getSlot(int index) {
        return (SlotLens)this.get(index);
    }

    public static class Builder {
        private List<Tuple<Class<? extends SlotAdapter>, SlotLensProvider>> slotTypes = new ArrayList<Tuple<Class<? extends SlotAdapter>, SlotLensProvider>>();
        private final SlotLensProvider defaultProvider = i -> new SlotLensImpl(i, this.slotTypes.get(i).getFirst());

        public Builder add() {
            return this.add(SlotAdapter.class);
        }

        public Builder add(Class<? extends SlotAdapter> type) {
            return this.add(type, this.defaultProvider);
        }

        public Builder add(Class<? extends SlotAdapter> type, SlotLensProvider provider) {
            this.slotTypes.add(Tuple.of(Preconditions.checkNotNull(type), provider));
            return this;
        }

        public Builder add(int count) {
            return this.add(count, SlotAdapter.class, this.defaultProvider);
        }

        public Builder add(int count, Class<? extends SlotAdapter> type) {
            return this.add(count, type, this.defaultProvider);
        }

        public Builder add(int count, Class<? extends SlotAdapter> type, SlotLensProvider provider) {
            Preconditions.checkNotNull(type);
            for (int i = 0; i < count; ++i) {
                this.add(type, provider);
            }
            return this;
        }

        public int size() {
            return this.slotTypes.size();
        }

        SlotLensProvider getProvider(int index) {
            return this.slotTypes.get(index).getSecond();
        }

        public SlotCollection build() {
            return new SlotCollection(this.size(), this);
        }
    }
}

