/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.management;

import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.server.management.PlayerProfileCache;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.profile.GameProfileCache;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.server.management.PlayerProfileCacheBridge;
import org.spongepowered.common.util.SpongeUsernameCache;

@Mixin(value={PlayerProfileCache.class})
public abstract class PlayerProfileCacheMixin
implements PlayerProfileCacheBridge {
    private Queue<GameProfile> impl$profiles = new ConcurrentLinkedQueue<GameProfile>();
    private boolean impl$canSave = false;

    @Shadow
    public abstract void func_152658_c();

    @Override
    public void bridge$setCanSave(boolean flag) {
        this.impl$canSave = flag;
    }

    @Inject(method={"addEntry(Lcom/mojang/authlib/GameProfile;Ljava/util/Date;)V"}, at={@At(value="RETURN")})
    private void impl$UpdateCacheUsername(GameProfile profile, Date date, CallbackInfo ci) {
        SpongeUsernameCache.setUsername(profile.getId(), profile.getName());
    }

    @Redirect(method={"addEntry(Lcom/mojang/authlib/GameProfile;Ljava/util/Date;)V"}, at=@At(value="INVOKE", target="Ljava/util/Deque;remove(Ljava/lang/Object;)Z", remap=false))
    private boolean impl$RemoveFromOurQueue(Deque<GameProfile> list, Object obj) {
        return this.impl$profiles.remove(obj);
    }

    @Redirect(method={"addEntry(Lcom/mojang/authlib/GameProfile;Ljava/util/Date;)V"}, at=@At(value="INVOKE", target="Ljava/util/Deque;addFirst(Ljava/lang/Object;)V", remap=false))
    private void impl$onAddEntryAdd(Deque<GameProfile> list, Object obj) {
        this.impl$profiles.add((GameProfile)obj);
    }

    @Redirect(method={"getGameProfileForUsername"}, at=@At(value="INVOKE", target="Ljava/util/Deque;remove(Ljava/lang/Object;)Z", remap=false))
    private boolean impl$onGetGameProfileForUsernameRemove1(Deque<GameProfile> list, Object obj) {
        return this.impl$profiles.remove(obj);
    }

    @Redirect(method={"getGameProfileForUsername"}, at=@At(value="INVOKE", target="Ljava/util/Deque;addFirst(Ljava/lang/Object;)V", remap=false))
    private void impl$addToOurProfiles(Deque<GameProfile> list, Object obj) {
        this.impl$profiles.add((GameProfile)obj);
    }

    @Redirect(method={"getByUUID"}, at=@At(value="INVOKE", target="Ljava/util/Deque;remove(Ljava/lang/Object;)Z", remap=false))
    private boolean impl$RemoveFromOurProfiles(Deque<GameProfile> list, Object obj) {
        return this.impl$profiles.remove(obj);
    }

    @Redirect(method={"getByUUID"}, at=@At(value="INVOKE", target="Ljava/util/Deque;addFirst(Ljava/lang/Object;)V", remap=false))
    private void impl$useOurProfiles(Deque<GameProfile> list, Object obj) {
        this.impl$profiles.add((GameProfile)obj);
    }

    @Redirect(method={"getEntriesWithLimit"}, at=@At(value="INVOKE", target="Ljava/util/Deque;iterator()Ljava/util/Iterator;", remap=false))
    private Iterator<GameProfile> impl$useOurIterator(Deque<GameProfile> list) {
        return this.impl$profiles.iterator();
    }

    @Redirect(method={"load"}, at=@At(value="INVOKE", target="Ljava/util/Deque;clear()V", remap=false))
    private void impl$ClearOurProfiles(Deque<GameProfile> list) {
        this.impl$profiles.clear();
    }

    @Redirect(method={"lookupProfile(Lcom/mojang/authlib/GameProfileRepository;Ljava/lang/String;)Lcom/mojang/authlib/GameProfile;"}, at=@At(value="INVOKE", target="Lcom/mojang/authlib/GameProfileRepository;findProfilesByNames([Ljava/lang/String;Lcom/mojang/authlib/Agent;Lcom/mojang/authlib/ProfileLookupCallback;)V", remap=false))
    private static void impl$LookUpViaSponge(GameProfileRepository repository, String[] names, Agent agent, ProfileLookupCallback callback) {
        GameProfileCache cache = null;
        try {
            cache = Sponge.getServer().getGameProfileManager().getCache();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cache == null || cache instanceof PlayerProfileCache) {
            repository.findProfilesByNames(names, agent, callback);
        } else {
            callback.onProfileLookupSucceeded((GameProfile)cache.getOrLookupByName(names[0]).orElse(null));
        }
    }

    @Inject(method={"save"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$IgnoreSavingIfCancelled(CallbackInfo ci) {
        if (!this.impl$canSave) {
            ci.cancel();
        }
    }
}

