/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.DimensionTypes;
import org.spongepowered.api.world.PortalAgentType;
import org.spongepowered.api.world.PortalAgentTypes;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.SerializationBehaviors;
import org.spongepowered.api.world.difficulty.Difficulties;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.gen.WorldGeneratorModifier;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.bridge.world.WorldSettingsBridge;
import org.spongepowered.common.registry.type.world.WorldGeneratorModifierRegistryModule;
import org.spongepowered.common.util.Constants;

@Mixin(value={WorldSettings.class})
public abstract class WorldSettingsMixin
implements WorldSettingsBridge {
    @Shadow
    private boolean field_77168_f;
    @Shadow
    private String field_82751_h;
    @Nullable
    private String id;
    @Nullable
    private String name;
    private DimensionType dimensionType = DimensionTypes.OVERWORLD;
    private Difficulty difficulty = Difficulties.NORMAL;
    private SerializationBehavior serializationBehavior = SerializationBehaviors.AUTOMATIC;
    private DataContainer generatorSettings = DataContainer.createNew();
    private boolean isEnabled = true;
    private boolean loadOnStartup = true;
    @Nullable
    private Boolean keepSpawnLoaded = null;
    private boolean generateSpawnOnLoad = false;
    private boolean pvpEnabled = true;
    private boolean generateBonusChest = false;
    @Nullable
    private PortalAgentType portalAgentType;
    private Collection<WorldGeneratorModifier> generatorModifiers = ImmutableList.of();
    private boolean seedRandomized = false;

    @Shadow
    public abstract GameType func_77162_e();

    @Inject(method={"<init>(Lnet/minecraft/world/storage/WorldInfo;)V"}, at={@At(value="RETURN")})
    private void impl$reAssignValuesFromIncomingInfo(WorldInfo info, CallbackInfo ci) {
        WorldProperties properties = (WorldProperties)info;
        if (((WorldInfoBridge)info).bridge$getConfigAdapter() != null) {
            this.dimensionType = properties.getDimensionType();
            this.difficulty = properties.getDifficulty();
            this.serializationBehavior = properties.getSerializationBehavior();
            this.generatorSettings = properties.getGeneratorSettings().copy();
            this.isEnabled = properties.isEnabled();
            this.loadOnStartup = properties.loadOnStartup();
            this.keepSpawnLoaded = properties.doesKeepSpawnLoaded();
            this.generateSpawnOnLoad = properties.doesGenerateSpawnOnLoad();
            this.pvpEnabled = properties.isPVPEnabled();
            this.generateBonusChest = properties.doesGenerateBonusChest();
            WorldGeneratorModifierRegistryModule.getInstance().checkAllRegistered(properties.getGeneratorModifiers());
            this.generatorModifiers = ImmutableList.copyOf(properties.getGeneratorModifiers());
        }
    }

    @Override
    public String bridge$getId() {
        return this.id;
    }

    @Override
    public String bridge$getName() {
        return this.name;
    }

    @Override
    public boolean bridge$isSeedRandomized() {
        return this.seedRandomized;
    }

    @Override
    public void bridge$setRandomSeed(boolean state) {
        this.seedRandomized = state;
    }

    @Inject(method={"setGeneratorOptions"}, at={@At(value="RETURN")})
    private void onSetGeneratorOptions(String generatorOptions, CallbackInfoReturnable<WorldSettings> cir) {
        DataContainer settings = null;
        try {
            settings = DataFormats.JSON.read(generatorOptions);
        }
        catch (JsonParseException | IOException throwable) {
            // empty catch block
        }
        if (settings == null) {
            settings = DataContainer.createNew().set(Constants.Sponge.World.WORLD_CUSTOM_SETTINGS, (Object)generatorOptions);
        }
        this.generatorSettings = settings;
    }

    @Override
    public boolean bridge$getGeneratesBonusChest() {
        return this.generateBonusChest;
    }

    @Override
    public DimensionType bridge$getDimensionType() {
        return this.dimensionType;
    }

    @Override
    public Difficulty bridge$getDifficulty() {
        return this.difficulty;
    }

    @Override
    public PortalAgentType bridge$getPortalAgentType() {
        if (this.portalAgentType == null) {
            this.portalAgentType = PortalAgentTypes.DEFAULT;
        }
        return this.portalAgentType;
    }

    @Override
    public void bridge$setPortalAgentType(PortalAgentType type) {
        this.portalAgentType = type;
    }

    @Override
    public DataContainer bridge$getGeneratorSettings() {
        return this.generatorSettings;
    }

    @Override
    public SerializationBehavior bridge$getSerializationBehavior() {
        return this.serializationBehavior;
    }

    @Override
    public boolean bridge$isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean bridge$loadOnStartup() {
        return this.loadOnStartup;
    }

    @Override
    public boolean bridge$doesKeepSpawnLoaded() {
        if (this.keepSpawnLoaded == null) {
            this.keepSpawnLoaded = this.dimensionType == DimensionTypes.OVERWORLD;
        }
        return this.keepSpawnLoaded;
    }

    @Override
    public boolean bridge$generateSpawnOnLoad() {
        return this.generateSpawnOnLoad;
    }

    @Override
    public boolean bridge$isPVPEnabled() {
        return this.pvpEnabled;
    }

    @Override
    public Collection<WorldGeneratorModifier> bridge$getGeneratorModifiers() {
        return this.generatorModifiers;
    }

    @Override
    public void bridge$setId(String id) {
        Preconditions.checkNotNull((Object)id);
        if (this.id != null) {
            throw new IllegalStateException("Attempt made to set id twice!");
        }
        this.id = id;
    }

    @Override
    public void bridge$setName(String name) {
        Preconditions.checkNotNull((Object)name);
        if (this.name != null) {
            throw new IllegalStateException("Attempt made to set name twice!");
        }
        this.name = name;
    }

    @Override
    public void bridge$setDimensionType(DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    @Override
    public void bridge$setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    @Override
    public void bridge$setSerializationBehavior(SerializationBehavior behavior) {
        this.serializationBehavior = behavior;
    }

    @Override
    public void bridge$setGeneratorSettings(DataContainer generatorSettings) {
        Optional<String> optCustomSettings = generatorSettings.getString(Constants.Sponge.World.WORLD_CUSTOM_SETTINGS);
        if (optCustomSettings.isPresent()) {
            this.field_82751_h = optCustomSettings.get();
        } else {
            try {
                this.field_82751_h = DataFormats.JSON.write(generatorSettings);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.generatorSettings = generatorSettings;
    }

    @Override
    public void bridge$setGeneratorModifiers(ImmutableList<WorldGeneratorModifier> generatorModifiers) {
        this.generatorModifiers = generatorModifiers;
    }

    @Override
    public void bridge$setEnabled(boolean state) {
        this.isEnabled = state;
    }

    @Override
    public void bridge$setLoadOnStartup(boolean state) {
        this.loadOnStartup = state;
    }

    @Override
    public void bridge$setKeepSpawnLoaded(@Nullable Boolean state) {
        this.keepSpawnLoaded = state;
    }

    @Override
    public void bridge$setGenerateSpawnOnLoad(boolean state) {
        this.generateSpawnOnLoad = state;
    }

    @Override
    public void bridge$setPVPEnabled(boolean state) {
        this.pvpEnabled = state;
    }

    @Override
    public void bridge$setCommandsAllowed(boolean state) {
        this.field_77168_f = state;
    }

    @Override
    public void bridge$setGenerateBonusChest(boolean state) {
        this.generateBonusChest = state;
    }

    @Override
    public Boolean bridge$internalKeepSpawnLoaded() {
        return this.keepSpawnLoaded;
    }
}

