/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core;

import com.atherys.core.CoreConfig;
import com.atherys.core.combat.CombatLog;
import com.atherys.core.command.CommandService;
import com.atherys.core.db.DatabaseContext;
import com.atherys.core.event.AtherysHibernateInitializedEvent;
import com.atherys.core.serialize.DurationTypeSerializer;
import com.atherys.core.template.TemplateEngine;
import com.atherys.core.utils.EntityUtils;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GameStoppedServerEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.economy.EconomyService;

@Plugin(id="atheryscore", version="2.0.0", name="A'therys Core", description="The core utilities used on the A'therys Horizons server.")
public class AtherysCore {
    public static final String ID = "atheryscore";
    public static final String NAME = "A'therys Core";
    public static final String DESCRIPTION = "The core utilities used on the A'therys Horizons server.";
    public static final String VERSION = "2.0.0";
    private static AtherysCore instance;
    private static boolean init;
    @Inject
    private Logger logger;
    @Inject
    PluginContainer container;
    private CoreConfig coreConfig;
    private TemplateEngine templateEngine;
    private EconomyService economyService;
    private CombatLog combatLog;
    private DatabaseContext databaseContext;

    private void init() {
        instance = this;
        this.templateEngine = new TemplateEngine();
        TypeSerializers.getDefaultSerializers().registerType(TypeToken.of(Duration.class), (TypeSerializer)new DurationTypeSerializer());
        try {
            this.coreConfig = new CoreConfig();
            this.coreConfig.init();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.coreConfig.DB_ENABLED) {
            this.databaseContext = new DatabaseContext(this.coreConfig.JPA_CONFIG, this.logger);
        }
        this.economyService = Sponge.getServiceManager().provide(EconomyService.class).orElse(null);
        this.combatLog = new CombatLog();
        this.combatLog.init();
        Sponge.getEventManager().post((Event)new AtherysHibernateInitializedEvent(this.databaseContext.getEntityManagerFactory()));
        init = true;
    }

    private void stopped() {
        if (this.coreConfig.DB_ENABLED) {
            this.databaseContext.close();
        }
    }

    @Listener(order=Order.FIRST)
    public void onInit(GameInitializationEvent event) {
        this.init();
    }

    @Listener
    public void onStopped(GameStoppedServerEvent event) {
        if (init) {
            this.stopped();
        }
    }

    @Listener
    public void onPlayerDamage(DamageEntityEvent event, @Root EntityDamageSource source, @Getter(value="getTargetEntity") Player victim) {
        Entity rootEntity = EntityUtils.getRootEntity(source);
        if (!(rootEntity instanceof Player)) {
            return;
        }
        this.combatLog.initiateCombat((Player)rootEntity, victim);
    }

    @Listener
    public void onPlayerDeath(DestructEntityEvent.Death event, @Root Player attacker, @Getter(value="getTargetEntity") Player victim) {
        this.combatLog.endCombat(attacker, victim);
    }

    public static CommandService getCommandService() {
        return CommandService.getInstance();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static CoreConfig getConfig() {
        return AtherysCore.getInstance().coreConfig;
    }

    public static AtherysCore getInstance() {
        return instance;
    }

    public static EntityManagerFactory getEntityManagerFactory() {
        return AtherysCore.getDatabaseContext().getEntityManagerFactory();
    }

    public static TemplateEngine getTemplateEngine() {
        return AtherysCore.getInstance().templateEngine;
    }

    public static CombatLog getCombatLog() {
        return AtherysCore.getInstance().combatLog;
    }

    public static DatabaseContext getDatabaseContext() {
        return AtherysCore.getInstance().databaseContext;
    }

    public static Optional<EconomyService> getEconomyService() {
        return Optional.ofNullable(AtherysCore.getInstance().economyService);
    }

    static {
        init = false;
    }
}

