/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.combat;

import com.atherys.core.AtherysCore;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scheduler.Task;

public class CombatLog {
    private Set<Entry> log = new HashSet<Entry>();
    private Task cleanup;

    public void init() {
        this.cleanup = Task.builder().intervalTicks(20L).execute(() -> {
            long currentMillis = System.currentTimeMillis();
            this.log.removeIf(entry -> currentMillis - entry.getInitiationTime() >= AtherysCore.getConfig().COMBAT_LIMIT.toMillis());
        }).submit((Object)AtherysCore.getInstance());
    }

    public Optional<Player> fetchAttacker(Player playerA, Player playerB) {
        return this.log.stream().filter(entry -> entry.getAttacker().equals(playerA.getUniqueId()) && entry.getVictim().equals(playerB.getUniqueId()) || entry.getAttacker().equals(playerB.getUniqueId()) && entry.getVictim().equals(playerA.getUniqueId())).map(entry -> {
            if (entry.getAttacker().equals(playerA.getUniqueId())) {
                return playerA;
            }
            return playerB;
        }).findAny();
    }

    public Optional<Player> fetchVictim(Player playerA, Player playerB) {
        return this.fetchAttacker(playerA, playerB).map(attacker -> {
            if (attacker.getUniqueId().equals(playerA.getUniqueId())) {
                return playerB;
            }
            return playerA;
        });
    }

    public Optional<Long> fetchLatestCombatLogTimestamp(Player player) {
        return this.log.stream().filter(entry -> entry.getAttacker().equals(player.getUniqueId()) || entry.getVictim().equals(player.getUniqueId())).map(Entry::getInitiationTime).sorted().findFirst();
    }

    public void initiateCombat(Player attacker, Player victim) {
        this.log.add(new Entry(attacker.getUniqueId(), victim.getUniqueId(), System.currentTimeMillis()));
    }

    public void endCombat(Player attacker, Player victim) {
        this.log.removeIf(entry -> entry.getAttacker().equals(attacker.getUniqueId()) && entry.getVictim().equals(victim.getUniqueId()));
    }

    public boolean isInCombat(Player player) {
        return this.log.stream().anyMatch(entry -> entry.getAttacker().equals(player.getUniqueId()) || entry.getVictim().equals(player.getUniqueId()));
    }

    private static class Entry {
        private UUID attacker;
        private UUID victim;
        private Long initiationTime;

        public Entry(UUID attacker, UUID victim, Long initiationTime) {
            this.attacker = attacker;
            this.victim = victim;
            this.initiationTime = initiationTime;
        }

        public UUID getAttacker() {
            return this.attacker;
        }

        public void setAttacker(UUID attacker) {
            this.attacker = attacker;
        }

        public UUID getVictim() {
            return this.victim;
        }

        public void setVictim(UUID victim) {
            this.victim = victim;
        }

        public Long getInitiationTime() {
            return this.initiationTime;
        }

        public void setInitiationTime(Long initiationTime) {
            this.initiationTime = initiationTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return Objects.equals(this.getAttacker(), entry.getAttacker()) && Objects.equals(this.getVictim(), entry.getVictim()) && Objects.equals(this.getInitiationTime(), entry.getInitiationTime());
        }

        public int hashCode() {
            return Objects.hash(this.getAttacker(), this.getVictim(), this.getInitiationTime());
        }
    }
}

