/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.command;

import com.atherys.core.command.ParameterizedCommand;
import com.atherys.core.command.annotation.Aliases;
import com.atherys.core.command.annotation.Children;
import com.atherys.core.command.annotation.Description;
import com.atherys.core.command.annotation.HelpCommand;
import com.atherys.core.command.annotation.Permission;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;

public final class CommandService {
    private static CommandService instance = new CommandService();

    public static CommandService getInstance() {
        return instance;
    }

    public <T extends CommandExecutor> void register(T executor, Object plugin) throws AnnotatedCommandException {
        Command command = this.buildCommandSpec(executor);
        Sponge.getCommandManager().register(plugin, (CommandCallable)command.getSpec(), command.getAliases());
    }

    public <T extends CommandExecutor> Command buildCommandSpec(T command) throws AnnotatedCommandException {
        Class<?> commandClass = command.getClass();
        String[] aliases = this.getAliases(commandClass);
        CommandSpec.Builder spec = CommandSpec.builder();
        CommandService.getAnnotation(commandClass, Description.class).ifPresent(description -> spec.description((Text)Text.of((String)description.value())));
        CommandService.getAnnotation(commandClass, Permission.class).ifPresent(permission -> spec.permission(permission.value()));
        ArrayList<Command> children = new ArrayList<Command>();
        if (commandClass.isAnnotationPresent(Children.class)) {
            Class<? extends CommandExecutor>[] childCommandClasses;
            if (command instanceof ParameterizedCommand) {
                throw AnnotatedCommandException.parentParameterizedCommand(commandClass);
            }
            for (Class<? extends CommandExecutor> child : childCommandClasses = commandClass.getAnnotation(Children.class).value()) {
                Command childSpec;
                try {
                    childSpec = this.buildCommandSpec(child.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw AnnotatedCommandException.childInstantiation(child);
                }
                spec.child((CommandCallable)childSpec.getSpec(), childSpec.getAliases());
                children.add(childSpec);
            }
        }
        if (command instanceof ParameterizedCommand) {
            ParameterizedCommand parameterizedCommand = (ParameterizedCommand)command;
            spec.arguments(parameterizedCommand.getArguments());
        }
        spec.executor(command);
        CommandSpec commandSpec = spec.build();
        Command com = new Command(commandSpec, children, aliases);
        CommandService.getAnnotation(commandClass, HelpCommand.class).ifPresent(help -> {
            CommandExecutor helpCommand = this.createHelpCommand(com, (HelpCommand)help);
            if (help.command().isEmpty()) {
                spec.executor(helpCommand);
            } else {
                String permission = CommandService.getAnnotation(commandClass, Permission.class).map(Permission::value).orElse(null);
                CommandSpec helpSpec = CommandSpec.builder().executor(helpCommand).permission(permission).build();
                spec.child((CommandCallable)helpSpec, new String[]{help.command()});
            }
            com.spec = spec.build();
        });
        return com;
    }

    private static <A extends Annotation> Optional<A> getAnnotation(Class clazz, Class<A> annotation) {
        return Optional.ofNullable(clazz.getAnnotation(annotation));
    }

    private CommandExecutor createHelpCommand(Command command, HelpCommand annotation) {
        if (command.children.size() == 0) {
            return command.spec.getExecutor();
        }
        PaginationList.Builder helpList = PaginationList.builder().title(Text.of((Object[])new Object[]{TextColors.GOLD, TextStyles.BOLD, annotation.title()})).padding(Text.of((Object[])new Object[]{TextColors.DARK_GRAY, "="}));
        LinkedHashMap<Command, Text> helpText = new LinkedHashMap<Command, Text>();
        helpText.put(command, this.getHelpForBase(command, annotation));
        for (Command child : command.children) {
            helpText.put(child, this.getHelpForSub(child, annotation, command.aliases[0]));
        }
        return (src, args) -> {
            List filtered = helpText.entrySet().stream().filter(entry -> ((Command)entry.getKey()).getSpec().testPermission(src)).map(Map.Entry::getValue).collect(Collectors.toList());
            helpList.contents(filtered).sendTo((MessageReceiver)src);
            return CommandResult.success();
        };
    }

    private Text getHelpForBase(Command command, HelpCommand annotation) {
        return this.getHelpFor(command, annotation, command.aliases[0], "");
    }

    private Text getHelpForSub(Command command, HelpCommand annotation, String base) {
        return this.getHelpFor(command, annotation, base + " ", command.aliases[0]);
    }

    private Text getHelpFor(Command command, HelpCommand annotation, String base, String alias) {
        Text.Builder help = Text.builder();
        String prefix = "";
        if (!annotation.prefix().isEmpty()) {
            prefix = annotation.prefix() + " ";
        }
        Text commandText = Text.of((Object[])new Object[]{TextColors.GOLD, "/" + prefix + base + alias});
        help.append(new Text[]{commandText}).onClick((ClickAction)TextActions.suggestCommand((String)commandText.toPlain())).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{commandText})));
        if (command.getChildren().size() == 0) {
            help.append(new Text[]{Text.of((Object[])new Object[]{" ", command.getSpec().getUsage((CommandSource)this.console())})});
        }
        command.getSpec().getShortDescription((CommandSource)this.console()).ifPresent(desc -> help.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, " : ", desc})}));
        return help.build();
    }

    private ConsoleSource console() {
        return Sponge.getServer().getConsole();
    }

    private String[] getAliases(Class<? extends CommandExecutor> commandClass) throws AnnotatedCommandException {
        String[] aliases;
        if (!commandClass.isAnnotationPresent(Aliases.class)) {
            throw AnnotatedCommandException.noAliases(commandClass);
        }
        for (String alias : aliases = commandClass.getAnnotation(Aliases.class).value()) {
            if (!alias.isEmpty()) continue;
            throw AnnotatedCommandException.emptyAlias(commandClass);
        }
        return aliases;
    }

    public static class AnnotatedCommandException
    extends Exception {
        private AnnotatedCommandException(String error) {
            super(error);
        }

        public static AnnotatedCommandException noAliases(Class<?> commandClass) {
            return new AnnotatedCommandException("The " + commandClass.getName() + " class is not annotated with Aliases.");
        }

        public static AnnotatedCommandException emptyAlias(Class<?> commandClass) {
            return new AnnotatedCommandException("The " + commandClass.getName() + " class is annotated with an empty alias.");
        }

        public static AnnotatedCommandException childInstantiation(Class<?> commandClass) {
            return new AnnotatedCommandException("Failed to instantiate the " + commandClass.getName() + " class. Ensure this class has an accessible no-args constructor available.");
        }

        public static AnnotatedCommandException parentParameterizedCommand(Class<?> commandClass) {
            return new AnnotatedCommandException("The " + commandClass.getName() + " command class is both a parent ( Annotated with @Children ) and a ParameterizedCommand. Parent command ought not to have parameters.");
        }
    }

    public static class Command {
        String[] aliases;
        CommandSpec spec;
        List<Command> children;

        Command(CommandSpec spec, List<Command> children, String ... aliases) {
            this.children = children;
            this.aliases = aliases;
            this.spec = spec;
        }

        String[] getAliases() {
            return this.aliases;
        }

        CommandSpec getSpec() {
            return this.spec;
        }

        List<Command> getChildren() {
            return this.children;
        }
    }
}

