/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.db;

import com.atherys.core.db.HibernateRepository;
import com.atherys.core.db.Identifiable;
import com.atherys.core.db.cache.Cache;
import com.atherys.core.db.cache.SimpleCache;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;

public class CachedHibernateRepository<T extends Identifiable<ID>, ID extends Serializable>
extends HibernateRepository<T, ID> {
    protected Cache<T, ID> cache = new SimpleCache();

    public CachedHibernateRepository(Class<T> persistable) {
        super(persistable);
    }

    @Override
    public Optional<T> findById(ID id) {
        return this.cache.getById(id);
    }

    public Optional<T> findOne(Predicate<T> condition) {
        return this.cache.findOne(condition);
    }

    public Collection<T> findAll(Predicate<T> condition) {
        return this.cache.findAll(condition);
    }

    @Override
    public void saveOne(T entity) {
        super.saveOne(entity);
        this.cache.add(entity);
    }

    @Override
    public void saveAll(Collection<T> entities) {
        super.saveAll(entities);
        this.cache.addAll(entities);
    }

    @Override
    public void deleteOne(T entity) {
        super.deleteOne(entity);
        this.cache.remove(entity);
    }

    @Override
    public void deleteAll(Collection<T> entities) {
        super.deleteAll(entities);
        this.cache.removeAll(entities);
    }

    @Override
    public CompletableFuture<Void> saveOneAsync(T entity) {
        return CompletableFuture.runAsync(() -> this.saveOne(entity));
    }

    @Override
    public CompletableFuture<Void> saveAllAsync(Collection<T> entities) {
        return CompletableFuture.runAsync(() -> this.saveAll(entities));
    }

    @Override
    public CompletableFuture<Void> deleteOneAsync(T entity) {
        return CompletableFuture.runAsync(() -> this.deleteOne(entity));
    }

    @Override
    public CompletableFuture<Void> deleteAllAsync(Collection<T> entities) {
        return CompletableFuture.runAsync(() -> this.deleteAll(entities));
    }

    @Override
    public <R> void querySingle(String jpql, Class<R> result, Consumer<Query> setParams, Consumer<Optional<R>> resultConsumer) {
        throw new UnsupportedOperationException("Cannot query cached repositories. Use findAll, findOne, or extend a non-cached repository instead.");
    }

    @Override
    public <R> void queryMultiple(String jpql, Class<R> result, Consumer<Query> setParams, Consumer<Collection<R>> resultConsumer) {
        throw new UnsupportedOperationException("Cannot query cached repositories. Use findAll, findOne, or extend a non-cached repository instead.");
    }

    @Override
    public <R> void querySingle(CriteriaQuery<R> query, Consumer<Query> setParams, Consumer<Optional<R>> resultConsumer) {
        throw new UnsupportedOperationException("Cannot query cached repositories. Use findAll, findOne, or extend a non-cached repository instead.");
    }

    @Override
    public <R> void queryMultiple(CriteriaQuery<R> query, Consumer<Query> setParams, Consumer<Collection<R>> resultConsumer) {
        throw new UnsupportedOperationException("Cannot query cached repositories. Use findAll, findOne, or extend a non-cached repository instead.");
    }

    public void initCache() {
        CriteriaBuilder builder = this.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(this.persistable);
        Root variableRoot = query.from(this.persistable);
        query.select(variableRoot);
        super.queryMultiple(query, q -> {}, entities -> entities.forEach(entity -> this.cache.set(entity.getId(), (Identifiable)entity)));
    }

    public void flushCache() {
        super.saveAll(this.cache.getAll());
    }
}

