/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.db;

import com.atherys.core.db.JPAConfig;
import com.atherys.core.db.migration.DatabaseMigrator;
import com.atherys.core.event.AtherysHibernateConfigurationEvent;
import java.util.LinkedList;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Event;

public class DatabaseContext
implements AutoCloseable {
    private JPAConfig config;
    private EntityManagerFactory entityManagerFactory;

    public DatabaseContext(JPAConfig config, Logger logger2) {
        this.config = config;
        DatabaseMigrator migrator = new DatabaseMigrator(config, logger2);
        migrator.migrate();
        this.createEntityManagerFactory();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    private void createEntityManagerFactory() {
        MetadataSources metadataSources = new MetadataSources(this.configureServiceRegistry(this.config));
        this.addClasses(metadataSources);
        this.entityManagerFactory = metadataSources.buildMetadata().getSessionFactoryBuilder().build();
    }

    private ServiceRegistry configureServiceRegistry(JPAConfig config) {
        return new StandardServiceRegistryBuilder().applySettings(this.getProperties(config)).build();
    }

    private Properties getProperties(JPAConfig config) {
        Properties properties = new Properties();
        config.HIBERNATE.forEach(properties::setProperty);
        return properties;
    }

    private void addClasses(MetadataSources metadataSources) {
        LinkedList classes = new LinkedList();
        AtherysHibernateConfigurationEvent event = new AtherysHibernateConfigurationEvent(classes);
        Sponge.getEventManager().post((Event)event);
        classes.forEach(metadataSources::addAnnotatedClass);
    }

    @Override
    public void close() {
        if (this.entityManagerFactory != null) {
            this.entityManagerFactory.close();
        }
    }
}

