/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.db;

import com.atherys.core.AtherysCore;
import com.atherys.core.db.Identifiable;
import com.atherys.core.db.Repository;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class HibernateRepository<T extends Identifiable<ID>, ID extends Serializable>
implements Repository<T, ID> {
    protected SessionFactory sessionFactory;
    protected Class<T> persistable;

    public HibernateRepository(Class<T> persistable) {
        this.persistable = persistable;
        EntityManagerFactory entityManagerFactory = AtherysCore.getEntityManagerFactory();
        if (!(entityManagerFactory instanceof SessionFactory)) {
            throw new IllegalStateException("JPA implementation is not Hibernate ( EMF is not instance of SessionFactory ).");
        }
        this.sessionFactory = (SessionFactory)entityManagerFactory;
    }

    private void saveOrUpdate(T entity, Session session) {
        session.saveOrUpdate(entity);
    }

    private void delete(T entity, Session session) {
        session.delete(entity);
    }

    protected void transactionOf(Consumer<Session> sessionConsumer) {
        try (Session session = this.sessionFactory.openSession();){
            Transaction transaction = null;
            try {
                transaction = session.beginTransaction();
                sessionConsumer.accept(session);
                session.flush();
                transaction.commit();
            }
            catch (Exception e) {
                if (transaction != null) {
                    transaction.rollback();
                }
                e.printStackTrace();
            }
        }
    }

    protected CompletableFuture<Void> asyncTransactionOf(Consumer<Session> sessionConsumer) {
        return CompletableFuture.runAsync(() -> this.transactionOf(sessionConsumer));
    }

    @Override
    public Optional<T> findById(ID id) {
        Session session = this.sessionFactory.openSession();
        Identifiable result = (Identifiable)session.find(this.persistable, id);
        session.close();
        return Optional.ofNullable(result);
    }

    @Override
    public void saveOne(T entity) {
        this.transactionOf(session -> this.saveOrUpdate(entity, (Session)session));
    }

    @Override
    public void saveAll(Collection<T> entities) {
        this.transactionOf(session -> entities.forEach(entity -> this.saveOrUpdate((T)entity, (Session)session)));
    }

    @Override
    public void deleteOne(T entity) {
        this.transactionOf(session -> this.delete(entity, (Session)session));
    }

    @Override
    public void deleteAll(Collection<T> entities) {
        this.transactionOf(session -> entities.forEach(entity -> this.delete((T)entity, (Session)session)));
    }

    @Override
    public CompletableFuture<Void> saveOneAsync(T entity) {
        return this.asyncTransactionOf(session -> this.saveOrUpdate(entity, (Session)session));
    }

    @Override
    public CompletableFuture<Void> saveAllAsync(Collection<T> entities) {
        return this.asyncTransactionOf(session -> entities.forEach(entity -> this.saveOrUpdate((T)entity, (Session)session)));
    }

    @Override
    public CompletableFuture<Void> deleteOneAsync(T entity) {
        return this.asyncTransactionOf(session -> this.delete(entity, (Session)session));
    }

    @Override
    public CompletableFuture<Void> deleteAllAsync(Collection<T> entities) {
        return this.asyncTransactionOf(session -> entities.forEach(entity -> this.delete((T)entity, (Session)session)));
    }

    @Override
    public CriteriaBuilder getCriteriaBuilder() {
        return this.sessionFactory.getCriteriaBuilder();
    }

    @Override
    public void execute(String jpql, Consumer<Query> setParams) {
        try (Session session = this.sessionFactory.openSession();){
            org.hibernate.query.Query query = session.createQuery(jpql);
            setParams.accept(query);
            query.executeUpdate();
        }
    }

    @Override
    public <R> void querySingle(String jpql, Class<R> result, Consumer<Query> setParams, Consumer<Optional<R>> resultConsumer) {
        try (Session session = this.sessionFactory.openSession();){
            TypedQuery query = session.createQuery(jpql, (Class)result);
            setParams.accept(query);
            Object r = query.getSingleResult();
            resultConsumer.accept(Optional.ofNullable(r));
        }
    }

    @Override
    public <R> void queryMultiple(String jpql, Class<R> result, Consumer<Query> setParams, Consumer<Collection<R>> resultConsumer) {
        try (Session session = this.sessionFactory.openSession();){
            TypedQuery query = session.createQuery(jpql, (Class)result);
            setParams.accept(query);
            List r = query.getResultList();
            resultConsumer.accept(r);
        }
    }

    @Override
    public <R> void querySingle(CriteriaQuery<R> query, Consumer<Query> setParams, Consumer<Optional<R>> resultConsumer) {
        try (Session session = this.sessionFactory.openSession();){
            TypedQuery q = session.createQuery((CriteriaQuery)query);
            setParams.accept(q);
            Object r = q.getSingleResult();
            resultConsumer.accept(Optional.ofNullable(r));
        }
    }

    @Override
    public <R> void queryMultiple(CriteriaQuery<R> query, Consumer<Query> setParams, Consumer<Collection<R>> resultConsumer) {
        try (Session session = this.sessionFactory.openSession();){
            TypedQuery q = session.createQuery((CriteriaQuery)query);
            setParams.accept(q);
            List r = q.getResultList();
            resultConsumer.accept(r);
        }
    }
}

