/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.db;

import com.atherys.core.db.Identifiable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;

public interface Repository<T extends Identifiable<ID>, ID extends Serializable> {
    public Optional<T> findById(ID var1);

    public void saveOne(T var1);

    public void saveAll(Collection<T> var1);

    public void deleteOne(T var1);

    public void deleteAll(Collection<T> var1);

    public CompletableFuture<Void> saveOneAsync(T var1);

    public CompletableFuture<Void> saveAllAsync(Collection<T> var1);

    public CompletableFuture<Void> deleteOneAsync(T var1);

    public CompletableFuture<Void> deleteAllAsync(Collection<T> var1);

    public CriteriaBuilder getCriteriaBuilder();

    public void execute(String var1, Consumer<Query> var2);

    public <R> void querySingle(String var1, Class<R> var2, Consumer<Query> var3, Consumer<Optional<R>> var4);

    public <R> void queryMultiple(String var1, Class<R> var2, Consumer<Query> var3, Consumer<Collection<R>> var4);

    default public void executeAsync(String jpql, Consumer<Query> setParams) {
        CompletableFuture.runAsync(() -> this.execute(jpql, setParams));
    }

    default public <R> CompletableFuture<Void> querySingleAsync(String jpql, Class<R> result, Consumer<Query> setParams, Consumer<Optional<R>> resultConsumer) {
        return CompletableFuture.runAsync(() -> this.querySingle(jpql, result, setParams, resultConsumer));
    }

    default public <R> CompletableFuture<Void> queryMultipleAsync(String jpql, Class<R> result, Consumer<Query> setParams, Consumer<Collection<R>> resultConsumer) {
        return CompletableFuture.runAsync(() -> this.queryMultiple(jpql, result, setParams, resultConsumer));
    }

    public <R> void querySingle(CriteriaQuery<R> var1, Consumer<Query> var2, Consumer<Optional<R>> var3);

    public <R> void queryMultiple(CriteriaQuery<R> var1, Consumer<Query> var2, Consumer<Collection<R>> var3);

    default public <R> CompletableFuture<Void> querySingleAsync(CriteriaQuery<R> query, Consumer<Query> setParams, Consumer<Optional<R>> resultConsumer) {
        return CompletableFuture.runAsync(() -> this.querySingle(query, setParams, resultConsumer));
    }

    default public <R> CompletableFuture<Void> queryMultipleAsync(CriteriaQuery<R> query, Consumer<Query> setParams, Consumer<Collection<R>> resultConsumer) {
        return CompletableFuture.runAsync(() -> this.queryMultiple(query, setParams, resultConsumer));
    }
}

