/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.db.cache;

import com.atherys.core.db.Identifiable;
import com.atherys.core.db.cache.Cache;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ThreadsafeCache<T extends Identifiable<ID>, ID extends Serializable>
implements Cache<T, ID> {
    private Hashtable<ID, T> cache = new Hashtable();

    @Override
    public void set(ID id, T cacheable) {
        this.cache.put(id, cacheable);
    }

    @Override
    public void add(T cacheable) {
        this.cache.put(cacheable.getId(), cacheable);
    }

    @Override
    public void addAll(Collection<T> cacheables) {
        cacheables.forEach(this::add);
    }

    @Override
    public void remove(T cacheable) {
        this.cache.remove(cacheable.getId());
    }

    @Override
    public void removeById(ID id) {
        this.cache.remove(id);
    }

    @Override
    public void removeAll(Collection<T> cacheables) {
        cacheables.forEach(this::remove);
    }

    @Override
    public void removeIf(Predicate<T> condition) {
        this.cache.values().parallelStream().filter(condition).forEach(this::remove);
    }

    @Override
    public Optional<T> getById(ID id) {
        Identifiable cacheable = (Identifiable)this.cache.get(id);
        if (cacheable == null) {
            return Optional.empty();
        }
        return Optional.of(cacheable);
    }

    @Override
    public Collection<T> findAll(Predicate<T> query) {
        return this.cache.values().parallelStream().filter(query).collect(Collectors.toSet());
    }

    @Override
    public Optional<T> findOne(Predicate<T> query) {
        return this.cache.values().parallelStream().filter(query).findAny();
    }

    @Override
    public Collection<T> getAll() {
        return this.cache.values();
    }
}

