/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.db.migration;

import com.atherys.core.db.JPAConfig;
import com.atherys.core.event.AtherysDatabaseMigrationEvent;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Event;

public class DatabaseMigrator {
    private JPAConfig config;
    private Logger logger;

    public DatabaseMigrator(JPAConfig config, Logger logger2) {
        this.logger = logger2;
        this.config = config;
    }

    public void migrate() {
        this.logger.info("Beginning database migration...");
        String vendor = this.config.HIBERNATE.get("hibernate.connection.url").split(":")[1];
        AtherysDatabaseMigrationEvent event = new AtherysDatabaseMigrationEvent();
        Sponge.getEventManager().post((Event)event);
        event.getPluginIds().forEach(pluginId -> {
            String location = String.format("classpath:db/migration/%s/%s", pluginId, vendor);
            this.logger.info("Migrating " + location);
            FluentConfiguration cfg = new FluentConfiguration().dataSource(this.config.HIBERNATE.get("hibernate.connection.url"), this.config.HIBERNATE.get("hibernate.connection.username"), this.config.HIBERNATE.get("hibernate.connection.password")).schemas((String)pluginId).table("flyway_schema_history_" + pluginId).locations(location);
            new Flyway(cfg).migrate();
        });
        this.logger.info("Database migration complete.");
    }
}

