/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.facade;

import java.util.Collection;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextFormat;

public interface MessagingFacade {
    default public Text formatInfo(Object ... msg) {
        return Text.of((Object[])new Object[]{this.getPrefix(), this.getInfoFormat(), Text.of((Object[])msg)});
    }

    default public Text formatError(Object ... msg) {
        return Text.of((Object[])new Object[]{this.getPrefix(), this.getErrorFormat(), Text.of((Object[])msg)});
    }

    default public void info(MessageReceiver messageReceiver, Object ... msg) {
        messageReceiver.sendMessage(this.formatInfo(msg));
    }

    default public void info(Collection<MessageReceiver> receivers, Object ... msg) {
        receivers.forEach(receiver -> this.info((MessageReceiver)receiver, msg));
    }

    default public void broadcastInfo(Object ... msg) {
        Sponge.getServer().getBroadcastChannel().send(this.formatInfo(msg));
    }

    default public void error(MessageReceiver messageReceiver, Object ... msg) {
        messageReceiver.sendMessage(this.formatError(msg));
    }

    default public void error(Collection<MessageReceiver> receivers, Object ... msg) {
        receivers.forEach(receiver -> this.error((MessageReceiver)receiver, msg));
    }

    default public void broadcastError(Object ... msg) {
        Sponge.getServer().getBroadcastChannel().send(this.formatError(msg));
    }

    default public TextFormat getInfoFormat() {
        return TextFormat.of((TextColor)TextColors.GREEN);
    }

    default public TextFormat getErrorFormat() {
        return TextFormat.of((TextColor)TextColors.RED);
    }

    public Text getPrefix();
}

