/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.gson;

import com.atherys.core.AtherysCore;
import com.atherys.core.gson.AbstractTypeAdapter;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Optional;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.DataFormats;

public class SerializableTypeAdapter<T extends DataSerializable>
extends AbstractTypeAdapter<T> {
    private JsonParser parser = new JsonParser();

    protected SerializableTypeAdapter(Class<T> clazz) {
        super(clazz);
    }

    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            DataContainer view = DataFormats.JSON.read(json.toString());
            Optional object = view.getSerializable(DataQuery.of(), this.clazz);
            return (T)((DataSerializable)object.orElse(null));
        }
        catch (IOException e) {
            AtherysCore.getInstance().getLogger().info("Error deserializing type {}", (Object)typeOfT);
            return null;
        }
    }

    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        try {
            String json = DataFormats.JSON.write((DataView)src.toContainer());
            return this.parser.parse(json);
        }
        catch (IOException e) {
            AtherysCore.getInstance().getLogger().info("Error serializing type {}", (Object)typeOfSrc);
            return null;
        }
    }
}

