/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.gson;

import com.atherys.core.utils.RuntimeTypeAdapterFactory;
import com.google.gson.GsonBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class TypeAdapterFactoryRegistry {
    private Map<Class<?>, RuntimeTypeAdapterFactory<?>> typeAdapterFactoryMap = new HashMap();

    public <T> void add(Class<T> interfaceClass, RuntimeTypeAdapterFactory<T> rtaf) {
        this.typeAdapterFactoryMap.put(interfaceClass, rtaf);
    }

    public <T> void registerSubtype(Class<T> interfaceClass, Class<? extends T> implementation) {
        this.get(interfaceClass).ifPresent(typeAdapterFactory -> typeAdapterFactory.registerSubtype(implementation));
    }

    public final <T> void registerSubtypes(Class<T> interfaceClass, Collection<Class<? extends T>> implementations) {
        this.get(interfaceClass).ifPresent(typeAdapterFactory -> {
            for (Class implementation : implementations) {
                typeAdapterFactory.registerSubtype(implementation);
            }
        });
    }

    public <T> void registerSubtype(Class<T> interfaceClass, Class<? extends T> implementation, String identifier) {
        this.get(interfaceClass).ifPresent(typeAdapterFactory -> typeAdapterFactory.registerSubtype(implementation, identifier));
    }

    public <T> Optional<RuntimeTypeAdapterFactory<T>> get(Class<T> interfaceClass) {
        return Optional.ofNullable(this.typeAdapterFactoryMap.get(interfaceClass));
    }

    public void registerAll(GsonBuilder builder) {
        this.typeAdapterFactoryMap.values().forEach(arg_0 -> ((GsonBuilder)builder).registerTypeAdapterFactory(arg_0));
    }
}

