/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.interaction;

import com.atherys.core.interaction.AttachmentService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.spongepowered.api.entity.living.player.Player;

public abstract class AbstractAttachmentService<T>
implements AttachmentService<T> {
    private Map<UUID, T> attachers = new HashMap<UUID, T>();
    private Set<UUID> removers = new HashSet<UUID>();

    @Override
    public void startAttachment(Player player, T object) {
        this.attachers.put(player.getUniqueId(), object);
    }

    @Override
    public void endAttachment(Player player) {
        this.attachers.remove(player.getUniqueId());
    }

    @Override
    public Optional<T> getAttachment(Player player) {
        return Optional.ofNullable(this.attachers.get(player.getUniqueId()));
    }

    @Override
    public abstract void applyAttachment(Player var1);

    @Override
    public boolean isAttaching(Player player) {
        return this.attachers.containsKey(player.getUniqueId());
    }

    @Override
    public void startRemoval(Player player) {
        this.removers.add(player.getUniqueId());
    }

    @Override
    public void endRemoval(Player player) {
        this.removers.remove(player.getUniqueId());
    }

    @Override
    public boolean isRemoving(Player player) {
        return this.removers.contains(player.getUniqueId());
    }
}

