/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.menu;

import com.mcsimonflash.sponge.teslalibs.inventory.Action;
import com.mcsimonflash.sponge.teslalibs.inventory.Element;
import com.mcsimonflash.sponge.teslalibs.inventory.Layout;
import com.mcsimonflash.sponge.teslalibs.inventory.View;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.plugin.PluginContainer;

public class PlayerView {
    private View.Builder view;
    private Layout layout;
    private Consumer<Action<InteractInventoryEvent.Close>> onClose;
    private Map<Integer, Function<Player, Element>> updateableElements;
    private Map<UUID, View> players;

    public PlayerView(View.Builder view, Layout layout) {
        this.view = view;
        this.layout = layout;
        this.updateableElements = new HashMap<Integer, Function<Player, Element>>();
        this.players = new HashMap<UUID, View>();
    }

    public PlayerView(View.Builder view, Layout layout, Map<Integer, Function<Player, Element>> elements) {
        this(view, layout);
        this.updateableElements = elements;
    }

    public void setOnClose(Consumer<Action<InteractInventoryEvent.Close>> onClose) {
        this.onClose = onClose;
    }

    public void addUpdateableElement(int index, Function<Player, Element> element) {
        this.updateableElements.put(index, element);
    }

    public void updateElement(Player player, int element) {
        if (this.players.containsKey(player.getUniqueId()) && this.updateableElements.containsKey(element)) {
            this.players.get(player.getUniqueId()).setElement(element, this.updateableElements.get(element).apply(player));
        }
    }

    public void updateElements(Player player, int ... elements) {
        if (this.players.containsKey(player.getUniqueId())) {
            View view = this.players.get(player.getUniqueId());
            for (int i : elements) {
                view.setElement(i, this.updateableElements.get(i).apply(player));
            }
        }
    }

    public void updateAll(Player player) {
        if (this.players.containsKey(player.getUniqueId())) {
            View view = this.players.get(player.getUniqueId());
            this.updateableElements.forEach((index, element) -> view.setElement((int)index, (Element)element.apply(player)));
        }
    }

    public void switchToView(Player player, PlayerView playerView, PluginContainer container) {
        this.players.remove(player.getUniqueId());
        playerView.startView(player, container);
    }

    public void startView(Player player, PluginContainer container) {
        this.view.onClose(action -> {
            if (this.onClose != null) {
                this.onClose.accept((Action<InteractInventoryEvent.Close>)action);
            }
            this.players.remove(player.getUniqueId());
        });
        View playerView = this.view.build(container).define(this.layout);
        this.players.put(player.getUniqueId(), playerView);
        this.updateAll(player);
        playerView.open(player);
    }
}

