/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.serialize;

import com.google.common.reflect.TypeToken;
import java.time.Duration;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.apache.commons.lang3.StringUtils;

public class DurationTypeSerializer
implements TypeSerializer<Duration> {
    public Duration deserialize(TypeToken<?> type, ConfigurationNode value) throws ObjectMappingException {
        String val = value.getString();
        if (StringUtils.isEmpty((CharSequence)val)) {
            throw new ObjectMappingException("Cannot parse Duration: Is either null or empty string.");
        }
        String delimiter = "(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)";
        String[] tokens = val.split(delimiter);
        Duration result = Duration.ZERO;
        block14: for (int i = 1; i < tokens.length; ++i) {
            if (!tokens[i - 1].matches("\\d+")) continue;
            long amount = Long.parseLong(tokens[i - 1]);
            switch (tokens[i]) {
                case "S": {
                    result = result.plusMillis(amount);
                    continue block14;
                }
                case "s": {
                    result = result.plusSeconds(amount);
                    continue block14;
                }
                case "m": {
                    result = result.plusMinutes(amount);
                    continue block14;
                }
                case "h": {
                    result = result.plusHours(amount);
                    continue block14;
                }
                case "d": {
                    result = result.plusDays(amount);
                }
            }
        }
        return result;
    }

    public void serialize(TypeToken<?> type, Duration obj, ConfigurationNode value) throws ObjectMappingException {
        String result = "";
        if (obj != null) {
            long days = obj.toDays();
            obj = obj.minusDays(days);
            long hours = obj.toHours();
            obj = obj.minusHours(hours);
            long minutes = obj.toMinutes();
            obj = obj.minusMinutes(minutes);
            long seconds = obj.getSeconds();
            obj = obj.minusSeconds(seconds);
            long millis = obj.toMillis();
            result = (days == 0L ? "" : days + "d") + (hours == 0L ? "" : hours + "h") + (minutes == 0L ? "" : minutes + "m") + (seconds == 0L ? "" : seconds + "s") + (seconds == 0L ? "" : millis + "M");
        }
        value.setValue((Object)result);
    }
}

