/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.template;

import com.atherys.core.template.AbstractTemplate;
import java.util.ArrayList;
import java.util.List;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.BookView;
import org.spongepowered.api.text.Text;

public class BookTemplate
extends AbstractTemplate<BookView> {
    public static final Text BOOK_TEMPLATE_TITLE = Text.of((String)"Book Title");
    public static final Text BOOK_TEMPLATE_AUTHOR = Text.of((String)"Author");
    protected List<Text> pages = new ArrayList<Text>(50);
    protected int lastPageAdded = 0;

    protected void setPage(int index, Text page) {
        if (index < 0 || index >= this.pages.size()) {
            return;
        }
        this.pages.set(index, page);
    }

    protected void removePage(int index) {
        if (index < 0 || index >= this.pages.size()) {
            return;
        }
        this.pages.remove(index);
    }

    protected void addPage(Text page) {
        this.setPage(this.lastPageAdded++, page);
    }

    protected void removeLastPage() {
        this.removePage(this.lastPageAdded--);
    }

    @Override
    public BookView render() {
        BookView.Builder viewBuilder = BookView.builder().title(BOOK_TEMPLATE_TITLE).author(BOOK_TEMPLATE_AUTHOR);
        this.pages.forEach(page -> viewBuilder.addPage(this.applyAttributesTo((Text)page)));
        return viewBuilder.build();
    }

    @Override
    public void showTo(Player player) {
        player.sendBookView(this.render());
    }
}

