/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.template;

import com.atherys.core.template.Template;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;

public class TemplateAttributes {
    private Map<String, TextRepresentable> attributes = new HashMap<String, TextRepresentable>();

    public static Builder builder() {
        return new Builder();
    }

    public void addAttribute(String name, Object value) {
        if (ClassUtils.isPrimitiveOrWrapper(value.getClass()) || value instanceof String || value instanceof TextRepresentable) {
            this.attributes.put(name, (TextRepresentable)Text.of((Object[])new Object[]{value}));
            return;
        }
        for (Field field : value.getClass().getFields()) {
            String attribName = name + "." + field.getName();
            try {
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                this.addAttribute(attribName, field.get(value));
                field.setAccessible(accessible);
            }
            catch (IllegalAccessException e) {
                this.addAttribute(attribName, Template.DEFAULT_ATTRIBUTE_VALUE);
            }
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Text getAttribute(String name) {
        return this.attributes.getOrDefault(name, (TextRepresentable)Text.of((String)name)).toText();
    }

    public Map<String, TextRepresentable> getAttributes() {
        return this.attributes;
    }

    public static class Builder {
        TemplateAttributes attributes = new TemplateAttributes();

        public Builder add(String name, Object value) {
            this.attributes.addAttribute(name, value);
            return this;
        }

        public TemplateAttributes build() {
            return this.attributes;
        }
    }
}

