/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.utils;

import java.io.File;
import java.io.IOException;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.SimpleConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMapper;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;

public abstract class PluginConfig {
    protected ObjectMapper.BoundInstance configMapper;
    protected ConfigurationLoader<CommentedConfigurationNode> loader;
    protected ConfigurationOptions options;
    private boolean newFile = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PluginConfig(String directory, String filename) throws IOException {
        try {
            this.configMapper = ObjectMapper.forObject((Object)this);
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
        }
        File configFile = new File(directory + "/" + filename);
        if (!configFile.exists()) {
            if (!configFile.getParentFile().exists() && !configFile.getParentFile().mkdirs()) throw new IOException("Failed to create config directory " + directory);
            if (!configFile.createNewFile()) throw new IOException("Failed to create " + filename);
            this.newFile = true;
        }
        this.options = this.getOptions();
        this.loader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setDefaultOptions(this.options)).setPath(configFile.toPath())).build();
    }

    protected ConfigurationOptions getOptions() {
        return ConfigurationOptions.defaults();
    }

    public void save() {
        try {
            SimpleConfigurationNode out = SimpleConfigurationNode.root();
            this.configMapper.serialize((ConfigurationNode)out);
            this.loader.save((ConfigurationNode)out);
        }
        catch (IOException | ObjectMappingException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            this.configMapper.populate(this.loader.load(this.options));
        }
        catch (IOException | ObjectMappingException e) {
            e.printStackTrace();
        }
    }

    public void init() {
        if (this.newFile) {
            this.save();
        } else {
            this.load();
        }
    }
}

