/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.core.utils;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.BookView;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;

public final class Question {
    public static Text QUESTION_DECORATION_TOP = Text.of((Object[])new Object[]{TextColors.DARK_AQUA, "{", TextColors.AQUA, "Question", TextColors.DARK_AQUA, "}\n"});
    public static Text QUESTION_DECORATION_BOT = Text.of((Object[])new Object[]{TextColors.DARK_AQUA, "\n"});
    private static Map<UUID, Question> questions = new HashMap<UUID, Question>();
    private UUID id;
    private Text question;
    private List<Answer> answers;
    private Text decorationTop;
    private Text decorationBottom;

    Question(Text question) {
        this.question = question;
        this.answers = new LinkedList<Answer>();
        this.id = UUID.randomUUID();
        this.decorationTop = Text.EMPTY;
        this.decorationBottom = Text.EMPTY;
    }

    public static Builder of(Text question) {
        return new Builder(question);
    }

    public UUID getId() {
        return this.id;
    }

    public Text getQuestion() {
        return this.question;
    }

    public List<Answer> getAnswers() {
        return this.answers;
    }

    void addAnswer(Answer answer) {
        if (!this.answers.contains(answer)) {
            this.answers.add(answer);
        }
    }

    public Text asText() {
        Text.Builder builder = Text.builder();
        builder.append(new Text[]{this.decorationTop});
        builder.append(new Text[]{this.question});
        builder.append(new Text[]{Text.of((String)"\n")});
        for (Answer answer : this.answers) {
            builder.append(new Text[]{Text.of((Object[])new Object[]{TextStyles.RESET, TextColors.RESET, "["})});
            builder.append(new Text[]{Text.builder().append(new Text[]{answer.getText()}).onHover((HoverAction)TextActions.showText((Text)Text.of((String)"Click to answer"))).onClick((ClickAction)TextActions.executeCallback(source -> {
                if (!(source instanceof Player)) {
                    source.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Must be a player to reply to a question."}));
                    return;
                }
                if (questions.containsKey(this.id)) {
                    answer.execute((Player)source);
                    questions.remove(this.id);
                } else {
                    source.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You have already responded to that question!"}));
                }
            })).build()});
            builder.append(new Text[]{Text.of((Object[])new Object[]{TextStyles.RESET, TextColors.RESET, "] "})});
        }
        builder.append(new Text[]{this.decorationBottom});
        return builder.build();
    }

    public void register() {
        questions.put(this.id, this);
    }

    public void pollChat(@Nonnull Player player) {
        this.register();
        player.sendMessage(this.asText());
    }

    public void pollBook(@Nonnull Player player) {
        this.register();
        player.sendBookView(BookView.builder().addPage(this.asText()).build());
    }

    public void pollViewButton(@Nonnull Player player, @Nonnull Text buttonText) {
        this.register();
        Text text = Text.builder().append(new Text[]{buttonText}).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.AQUA, "Click to View"}))).onClick((ClickAction)TextActions.executeCallback(source -> {
            if (source instanceof Player) {
                this.pollBook((Player)source);
            }
        })).build();
        player.sendMessage(text);
    }

    public static class Answer {
        private Text text;
        private Consumer<Player> action;

        private Answer(Text text) {
            this.text = text;
        }

        private Answer(Text text, Consumer<Player> action) {
            this.text = text;
            this.action = action;
        }

        public static Answer of(Text name, Consumer<Player> action) {
            return new Answer(name, action);
        }

        public Text getText() {
            return this.text;
        }

        Consumer<Player> getAction() {
            return this.action;
        }

        public void setAction(Consumer<Player> action) {
            this.action = action;
        }

        public void execute(Player source) {
            this.action.accept(source);
        }
    }

    public static class Builder {
        private Question question;

        private Builder(Text question) {
            this.question = new Question(question);
        }

        public Builder addAnswer(Answer answer) {
            this.question.addAnswer(answer);
            return this;
        }

        public Builder topDecoration(Text text) {
            this.question.decorationTop = text;
            return this;
        }

        public Builder bottomDecoration(Text text) {
            this.question.decorationBottom = text;
            return this;
        }

        public Question build() {
            return this.question;
        }
    }
}

